/********************************************************/
/*		(C) COPYRIGHT 1983			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/********************************************************/

/* Vtermagent.h - Information shared by terminal agents and their clients.
 *
 * Kenneth Brooks, December 1983
 *    derived from keytable.h and Vgts.h
 *
 */

#ifndef VTERMAGENT
#define VTERMAGENT

/* Terminal agent special request codes */
#define SetBannerRequest 0x3800	
#define SwitchInput 0x2001
#define EventRequest 0x2002
#define RedrawRequest 0x2003
#define LineEditRequest 0x3804
#define GetRawIO 0x2004
#define ModifyPadRequest 0x2005
#define QueryPadRequest 0x2006
#define Die 0x2007


/* Line editor keytable entries */
enum EditKind
  {
  	/*
	 * This enumerated type gives the commands of the line editor.
	 * Keytables have these as entries.
	 */
    EditNop,		/* Do nothing */
    EditInsert,		/* Self inserting */
    EditRelease,	/* release the buffer (e.g. return) */
    EditReleaseLine,	/* EditRelease + echo CRLF */
    EditDeleteChar,	/* delete the last character */
    EditDeleteWord,	/* delete the last word */
    EditDeleteLine,	/* delete the last line */
    EditDeleteNextChar,	/* delete next character */
    EditDeleteNextWord,	/* delete next word */
    EditDeleteNextLine,	/* delete next line */
    EditForwardChar,	/* move forward character */
    EditForwardWord,	/* move forward word */
    EditForwardLine,	/* move forward line */
    EditBackwardChar,	/* move backward character */
    EditBackwardWord,	/* move backward word */
    EditBackwardLine,	/* move backward line */
    EditTransposeChar,	/* transpose two characters */
    EditBeginLine,	/* move to start of line */
    EditEndLine,	/* move to end of line */
    EditEscape,		/* go into Escape mode */
    EditKillBreak,	/* Kill the break process */
    EditEOF,		/* Cause End-Of-File */
    EditBeep,		/* Error, cause Bell to ring */
    EditInsertTab	/* Insert a tab */
  };


/* ModifyPad material */
struct ModifyMsg
  {
  	/*
	 * Message format for Modify requests
	 */
#ifndef LITTLE_ENDIAN
    short	requestcode;
    short	fileid;
    int		mode;
    short       lines;
    short	columns;
#else LITTLE_ENDIAN
    short	fileid;
    short	requestcode;
    int		mode;
    short	columns;
    short       lines;
#endif LITTLE_ENDIAN
    short	padding[10];
  };

/* standard ModifyPad bits */

#include <Vmodifypad.h>

/* The GetRawIO reply message */
typedef struct 
  {
#ifndef LITTLE_ENDIAN
    SystemCode	replycode;
    short 	unused;
    ProcessId 	inserver;
    ProcessId	outserver;
    InstanceId	infile;
    InstanceId	outfile;
#else LITTLE_ENDIAN
    short 	unused;
    SystemCode	replycode;
    ProcessId 	inserver;
    ProcessId	outserver;
    InstanceId	outfile;
    InstanceId	infile;
#endif LITTLE_ENDIAN
  } RawIOReply;

#endif VTERMAGENT
