/*
 * Distributed V Kernel
 * Copyright (c) 1984 by David Cheriton, Tim Mann
 *
 * RS-232 Serial communications line query and modify operations
 */

#ifndef VSERIAL
#define VSERIAL

/* Request message format */
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode requestcode;	/* MODIFY_FILE */
    short fileid;
    short charWidth;		/* 5, 6, 7, or 8 */
    short parity;		/* ODD, EVEN, or NONE */
    short dtr;			/* DTR RS232 output: 0 or 1 */
    short rts;			/* RTS RS232 output: 0 or 1 */
    short brk;			/* BREAK in progress? 0 or 1 */
    short stopBits;
#else LITTLE_ENDIAN
    short fileid;
    SystemCode requestcode;	/* MODIFY_FILE */
    short parity;		/* ODD, EVEN, or NONE */
    short charWidth;		/* 5, 6, 7, or 8 */
    short rts;			/* RTS RS232 output: 0 or 1 */
    short dtr;			/* DTR RS232 output: 0 or 1 */
    short stopBits;
    short brk;			/* BREAK in progress? 0 or 1 */
#endif LITTLE_ENDIAN
    unsigned dataRate;
    unsigned padding2[3];
  }    
ModifySerialDeviceRequest;



typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode replycode;
    short padding1;
    short charWidth;		/* 5, 6, 7, or 8 */
    short parity;		/* ODD, EVEN, or NONE */
    short dtr;			/* DTR RS232 output: 0 or 1 */
    short rts;			/* RTS RS232 output: 0 or 1 */
    short brk;			/* BREAK in progress? 0 or 1 */
    short stopBits;
#else LITTLE_ENDIAN
    short padding1;
    SystemCode replycode;
    short parity;		/* ODD, EVEN, or NONE */
    short charWidth;		/* 5, 6, 7, or 8 */
    short rts;			/* RTS RS232 output: 0 or 1 */
    short dtr;			/* DTR RS232 output: 0 or 1 */
    short stopBits;
    short brk;			/* BREAK in progress? 0 or 1 */
#endif LITTLE_ENDIAN
    unsigned dataRate;
    unsigned padding2[3];
  }    
QuerySerialDeviceReply;

#define QuerySerialDeviceRequest IoRequest
#define ModifySerialDeviceReply IoReply

#define PARITY_NONE	0
#define PARITY_ODD	1
#define PARITY_EVEN	2

#define STOP_BITS_15	0	/* 1.5 stop bits */
#define STOP_BITS_1	1	/* 1 stop bit */
#define STOP_BITS_2	2	/* 2 stop bits */

#endif VSERIAL
