/*
 * V Kernel - Copyright (c) 1981 by David Cheriton, All Rights reserved.
 * (Transliterated from Zed and Verex)
 * Copyright (c) 1982 Stanford University.
 *
 * V Kernel Process Manifests and Structs
 */

#ifndef VPROCESS
#define VPROCESS

#include "Venviron.h"
#include <Vprocessor.h>

/* Values for state field of process descriptor */
#define READY		1	/* Eligible for execution */
#define RECEIVE_BLKED	2	/* Blocked waiting for a message */
#define AWAITING_REPLY	3	/* Blocked until reply is received */
#define SEND_BLKED	4	/* Blocked sending a message */
#define AWAITING_INT	5	/* Awaiting device interrupt */
#define DELAYING	6	/* Blocked for clicks given by blocked_on */
#define GETPID_BLKED	7	/* Blocked for a remote GetPid */
#define MOVEFROM_BLKED  8	/* Blocked for remote MoveFrom */
#define MOVETO_BLKED	9	/* Blocked for remote MoveTo */
#define REPLIED_TO	10	/* Alien replied to */
#define FORWARDED_TO	11	/* Alien forwarded to */
#define LHN_COLLISION_BLKED 12	/* Blocked on logical host number collision
				   check. */
#define XMIT_BLKED	13	/* Blocked waiting for network transmission. */
#define ACTIVE		14	/* Currently executing. */


/* The following constant must be at least the size of the biggest 
 * possible "Processor_state" that we use (regardless of processor type).
 */
#define MAX_PROCESSOR_STATE_SIZE 200

/* Structure returned by QueryProcessState */
typedef struct
  {
    /* team fields */
    Process_id	team_root;
    unsigned short	team_priority;
    short	team_user;
    char	*team_size;
    /* process fields */
    Process_id  link;
    Process_id	father;
    Process_id  brother;
    Process_id	son;
    short	state;
    unsigned short	priority;
    Process_id	blocked_on;
    Process_id	forwardedby;
    char	msg[MSG_SIZE];
    Process_id  msg_queue;
    Process_id	msg_queue_end;
    union
      {
	Processor_state proc_state;
	char ps_filler[MAX_PROCESSOR_STATE_SIZE];
      }
    ps;
  } 
    ProcessBlock;
 
#define ByteSwapProcessBlock(pb) do { \
    ByteSwapLongInPlace(&((pb)->team_root), 1*sizeof(long)); \
    ByteSwapShortInPlace(&((pb)->team_priority), 2*sizeof(short)); \
    ByteSwapLongInPlace(&((pb)->team_size), 5*sizeof(long)); \
    ByteSwapShortInPlace(&((pb)->state), 2*sizeof(short)); \
    ByteSwapLongInPlace(&((pb)->blocked_on), 2*sizeof(long)); \
    ByteSwapLongInPlace(&((pb)->msg_queue), 2*sizeof(long)); \
    ByteSwapProcessor_state(&((pb)->ps.proc_state)); \
  } while (0)


#endif VPROCESS
