/*
 *  declarations for building infoBase
 *
 *  Cary Gray	March 1984
 */

typedef struct iFileListEntry {
    int  fileID;
    int  oldFileID;
    char fileName[FILE_NAME_STRING_LENGTH];
    struct iFileListEntry *nextFile;
    } iFileListEntry;

typedef struct iItemListEntry {
    char itemName[NAME_STRING_LENGTH];
    struct iItemListEntry *nextItem;
    int  referenceCount;
    int  attribsRemaining;
    iItem itemPtr;
    } iItemListEntry;

typedef struct iUpdateListEntry {
    iItemListEntry *item;
    iFileListEntry *file;
    struct iUpdateListEntry *nextEntry;
    } iUpdateListEntry;

typedef struct iIndexListEntry {
    char keyword[INDEX_KEYWORD_STRING_LENGTH];
    char attribName[NAME_STRING_LENGTH];
    iUpdateListEntry *updateEntry;
    struct iIndexListEntry *nextEntry;
    } iIndexListEntry;

#define NO_FILE_ID 0

/* in-package externals */
extern iOpenRead();
extern char *iFullItemDirName();

/* package exports */
extern iStartUpdate();
extern iEndUpdate();
extern iStartFile();
extern iEndFile();
extern iItem iStartItem();
extern iEndItem();
extern iAddAttrib();

extern iAbortUpdate();
