/*
 *  definitions for infoBase access
 *
 *  Cary Gray	March 1984
 */

#ifndef FILE
#include <stdio.h>
#endif

#define SUCCEED 0
#define FAIL -1
#define FAIL_FULL -2
#define FAIL_DUPLICATE -3

typedef short int boolean;
#define FALSE 0
#define TRUE 1

#define FILE_NAME_STRING_LENGTH 100
#define ATTRIBS_PER_ITEM 30
#define FILES_PER_ITEM 5
#define NAME_STRING_LENGTH 32
#define INDEX_KEYWORD_STRING_LENGTH 100

typedef int TableEntryType;
#define eEndTable	(-1)
#define eNoEntry	0
#define eFile		1
#define eAttrib		1
#define eDefaultAttrib	2


typedef struct iFileLine {
    TableEntryType type;
    int  fileID;
    char name[FILE_NAME_STRING_LENGTH];
    } iFileLine;

typedef struct iAttribLine {
    TableEntryType type;
    int  file;
    long offset;
    int  length;
    char name[NAME_STRING_LENGTH];
    } *iAttrib;

struct iItemIndex {
    char itemName[NAME_STRING_LENGTH];
    int  numAttribs;
    struct iAttribLine attrib[ATTRIBS_PER_ITEM];
    iFileLine file[FILES_PER_ITEM];
    };

typedef struct iItemRecord {
    FILE *filedes;
    int  openFile;
    iAttrib currentAttrib;
    int  currentChar;	/* w/in attrib */
    char mode;
    struct iItemIndex index;
    } *iItem;

#define NO_ATTRIB NULL
#define NO_FILE (-1)

/* exported access "functions" */
#define iItemName(i)		(((i)!=NULL)?(i)->index.itemName:NULL)
#define iNumberOfAttribs(i)	(((i)!=NULL)?(i)->index.numAttribs:0)
#define iCurrentAttrib(i)	(((i)!=NULL)?(i)->currentAttrib:NO_ATTRIB)
#define iFirstAttrib(i)		(((i)!=NULL)?(i->index.attrib):NO_ATTRIB)
#define iAttribName(a)		(((a)!=NO_ATTRIB)?(a)->name:NULL)
#define iAttribLength(a)	(((a)!=NO_ATTRIB)?(a)->length:0)
#define iAttribType(a)		(((a)!=NO_ATTRIB)?(a)->type:eNoEntry)

/* package imports */
extern iChangePrefix();
extern iItem iOpenItem();
extern iCloseItem();
extern iAttrib iNextAttrib();
extern iAttrib iPrevAttrib();
extern iAttrib iSeekAttrib();
extern iAttrib iFindNamedAttrib();
extern iGetcAttrib();
extern iUngetcAttrib();
extern iFindFirst();
extern iFindNext();
