/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * Virtual Graphics Terminal Protocol
 *
 * This information must be known by the VGTS and by the stub routines that
 * talk to it, but should not be needed by ordinary VGTS applications.
 *
 * Kenneth Brooks, September 1984
 */

#ifndef VGTP_HEADER
#define VGTP_HEADER

#include <Vgts.h>
#include <Venviron.h>

/*************************  byte stream protocol  ***************************/
/* Note: this enum must be kept in the same order as the ParseTable entries
 * in interp.c (in the VGTS directory).  If this order is changed, then both
 * interp.c AND the stubs library must be recompiled.
 */
#ifndef NEW_VGTS
    /* The following are applicable to the old VGTS only. */
enum VgtsRequest
  {
    VgtsCreateSDF,
    VgtsDeleteSDF,
    VgtsOldDefineSymbol,	/* for backward compatibility only! */
    VgtsOldEndSymbol,		/* for backward compatibility only! */
    VgtsAddItem,
    VgtsAddCall,
    VgtsDeleteItem,
    VgtsInquireItem,
    VgtsInquireCall,
    VgtsChangeItem,
    VgtsOldEditSymbol,		/* for backward compatibility only! */
    VgtsDeleteSymbol,
    VgtsCreateVGT,
    VgtsDeleteVGT,
    VgtsOldDisplayItem,		/* for backward compatibility only! */
    VgtsCreateView,
    VgtsGetMouseClick,
    VgtsFindSelectedObject,
    VgtsPopup,
    VgtsDefineFont,
    VgtsSetMode,
    VgtsDefaultView,
    VgtsDefineSymbol,
    VgtsEndSymbol,
    VgtsEditSymbol,
    VgtsDisplayItem
  };

#define VgtsMaxCode VgtsDisplayItem	/* highest code */
#define InterpEscape 037	/* VGTS interpreter escape char */
#else NEW_VGTS
    /* The following are applicable to the new (GKS compatible) VGTS only. */
enum VgtsRequest
  {
    VgtsDefineSymbol,
    VgtsEndSymbol,
    VgtsEditSymbol,
    VgtsDeleteSymbol,
    VgtsAddItem,
    VgtsAddAttribute,	/* a protocol optimization */
    VgtsDeleteItem,
    VgtsChangeItem,
    VgtsMoveItem,
    VgtsRelMoveItem,
    VgtsChangeText,
    VgtsChangeCall,
    VgtsDisplaySymbol,
    VgtsDefinePattern,
    VgtsDefineMarker,
    VgtsDefineFont
  };

#define VgtsMaxCode VgtsDefineFont	/* highest code */
#define SyncChar 037	/* VGTS interpreter escape char */
#endif NEW_VGTS

#define SIXTEEN 0xFFFF		/* sixteen bits of all ones */
#define MAGIC4 255		/* means there are four bytes */


/************************  message protocol  ***************************/
/* Applicable to the new (GKS compatible) VGTS only. */
#ifdef NEW_VGTS

/* VGTP message types: */

#define CREATE_SDF			0x6080
#define CREATE_VGT_GROUP		0x6081
#define INCLUDE_VGT			0x6082
#define EXCLUDE_VGT			0x6083
#define BIND_VGT			0x6084
#define CREATE_VIEW			0x4085
#define DEFAULT_VIEW			0x4086
#define REMAKE_VIEW			0x6087
#define DELETE_VIEW			0x6088
#define INQUIRE_ITEM			0x748a
#define INQUIRE_SYMBOL_CONTENTS		0x748b
#define INQUIRE_DEFINED_SYMBOLS		0x748c
#define SIMULATE_PICK			0x748d
#define POPUP				0x788e


typedef struct {
#ifndef LITTLE_ENDIAN
	SystemCode	requestcode;
	short		id;
	short		vgtgroup;
#else LITTLE_ENDIAN
	SystemCode	requestcode;
	short		id;
	short		filler;
	short		vgtgroup;
#endif LITTLE_ENDIAN
	}  SdfRequest;	/* used for request and reply */    

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode		requestcode;
    short unsigned	filenameindex;	/* First byte of filename to use */
    short unsigned	type;		/* The type of vgt to create */
    short unsigned	filemode;
    short unsigned	vgtgroup;
    short unsigned	sdf;		/* graphics VGT's only */
    short unsigned	height;		/* text VGT's only */
    short unsigned	width;		/* text VGT's only */
#else LITTLE_ENDIAN
    short unsigned	filenameindex;	/* First byte of filename to use */
    SystemCode		requestcode;
    short unsigned	filemode;
    short unsigned	type;		/* The type of vgt to create */
    short unsigned	sdf;		/* graphics VGT's only */
    short unsigned	vgtgroup;
    short unsigned	width;		/* text VGT's only */
    short unsigned	height;		/* text VGT's only */
#endif LITTLE_ENDIAN
    unsigned		unused;
    ContextId		contextid;	/* Context used to interpret name */
    char		*filename;
    unsigned		filenamelen;
  } CreateVgtRequest;

typedef struct {
#ifndef LITTLE_ENDIAN
	SystemCode requestcode;
	short vgt;
	short sdf;
	short topSymbol;
#else LITTLE_ENDIAN
	short vgt;
	SystemCode requestcode;
	short topSymbol;
	short sdf;
#endif LITTLE_ENDIAN
	}  BindVgtRequest;

typedef struct ViewRequest {	/* CreateView, DefaultView, RemakeView */
#ifndef LITTLE_ENDIAN
	SystemCode requestcode;
	short vgt;  	/* vgt is a view number in RemakeView and DeleteView */
	short screenxmin, screenymin;
	short width, height;
	short worldxmin, worldymin;
	short zoom, gridflag;
#else LITTLE_ENDIAN
	short vgt;  	/* vgt is a view number in RemakeView and DeleteView */
	SystemCode requestcode;
	short screenymin, screenxmin;
	short height, width;
	short worldymin, worldxmin;
	short gridflag, zoom;
#endif LITTLE_ENDIAN
	long flags;	/* for RemakeView */
	}  ViewRequest;

typedef struct {
#ifndef LITTLE_ENDIAN
	SystemCode requestcode;
	short fileid;
	short xmin, ymin;
	short xmax, ymax;  /* also used for radius, scale, called symbol, etc.*/
	short type;
	short ndata;	/* number of logical units of data */
#else LITTLE_ENDIAN
	short fileid;
	SystemCode requestcode;
	short ymin, xmin;
	short ymax, xmax;  /* also used for radius, scale, called symbol, etc.*/
	short ndata;	/* number of logical units of data */
	short type;
#endif LITTLE_ENDIAN
	long item;
	long unused[2];
	char *buffer;
	unsigned length;  /* actual length used */
	}  InquireRequest;


/****************************  Input requests  ******************************/

/* Message format for Popup requests */
typedef struct PopupRequest {
#ifndef LITTLE_ENDIAN
	SystemCode requestcode;
	short fileid;	/* used to determine whether this client is active */
	short n;	/* number of entries */
	short choice;	/* on reply, choice the user made */
#else LITTLE_ENDIAN
	short fileid;	/* used to determine whether this client is active */
	SystemCode requestcode;
	short choice;	/* on reply, choice the user made */
	short n;	/* number of entries */
#endif LITTLE_ENDIAN
	int unused[4];
	PopUpEntry *menu;
	unsigned menulength; /* length of menu in bytes */
	}  PopupRequest;

/* Message format for pick requests */
typedef struct PickRequest {
#ifndef LITTLE_ENDIAN
	SystemCode requestcode;
	short fileid;
	short x, y;
	short vgt;
	short pickid;		/* reply */
	short pickeditem;	/* reply */
	short pathlength;	/* reply */
#else LITTLE_ENDIAN
	short fileid;
	SystemCode requestcode;
	short y, x;
	short pickid;		/* reply */
	short vgt;
	short pathlength;	/* reply */
	short pickeditem;	/* reply */
#endif LITTLE_ENDIAN
	int unused[2];
	short *pathbuffer;
	unsigned buflength;
	}  PickRequest;

#endif NEW_VGTS


/* Vgts debugging codes, used in DebugVgts */
#define DebugVgtsMessages	0x1
#define DebugVgtsVgtp		0x2
#define DebugVgtsSdf		0x4
#define DebugVgtsWindows	0x8
#define DebugVgtsAttrib		0x10
#define DebugVgtsDraw		0x20

#define DebugVgtsEvents		0x40
#define DebugVgtsLineEdit	0x80
#define DebugVgtsManager	0x100
#define DebugVgtsFonts		0x200
#define DebugVgtsErrors		0x400

/* The following two must be used only with debugging redirected to the
 * console, because they control debugging information related to the text-
 * output process, and a recursive loop could result.
 */
#define DebugVgtsBasicDraw	0x4000
#define DebugVgtsPads 		0x8000

typedef struct DebugServerRequest {
#ifndef LITTLE_ENDIAN
	SystemCode requestcode;
	short fileid;
#else LITTLE_ENDIAN
	short fileid;
	SystemCode requestcode;
#endif LITTLE_ENDIAN
	int debugcode;
	int unused[6];
	} DebugServerRequest;

#endif VGTP_HEADER
