/* Vdisplay.h
 * 
 * Display server constants, request codes, and message formats shared
 * between the Display Server and clients.
 */

#ifndef VDISPLAY
#define VDISPLAY

#include "defines.h"

#ifdef VAX_UNIX

#include <stdio.h>
#include <Venviron.h>
#include <Vforunix.h>

#else
#ifdef VSYSTEM

#include "Vioprotocol.h"

#else

Error Error_UnknownOperatingSystem

#endif VSYSTEM
#endif VAX_UNIX

#include "Vgroupids.h"
#include "Vtermagent.h"
#include "modedata.h"
#include "dftypes.h"
#include "listtypes.h"
#include "standarddefs.h"
#include "minmax.h"


/* Debugging codes */

#define DebugRequests		0x00000001
#define DebugSdf		0x00000002
#define DebugBasicDraw		0x00000004
#define DebugViews		0x00000008
#define DebugFonts		0x00000010
#define DebugDraw		0x00000020
#define DebugTextFiles		0x00000040
#define DebugRasterFiles	0x00000080
#define DebugGraphicsFiles	0x00000100
#define DebugSubViews		0x00000200
#define DebugReplys		0x00000400
#define DebugRequestsDetail	0x00000800
#define DebugReplysDetail	0x00001000
#define DebugInterp		0x00002000

#define DebugErrors		0x80000000

/*
 * Operating system independent request codes for:
 * the raster graphics protocol, and
 * the structured graphics protocol.
 * Additions to the list should be made at the `end'.
 */

#define OsiFirstRequest		 1
#define SgpFirstRequest		 1

#define SgpUnknown		 0
#define RgpUnknown		 0

#define	SgpAddCall		 1
#define SgpAddComment		 2
#define	SgpAddItem		 3
#define	SgpChangeItem		 4
#define	SgpDefineFont		 5
#define	SgpDefineSymbol		 6
#define	SgpDeleteItem		 7
#define	SgpDeleteSymbol		 8
#define	SgpEditSymbol		 9
#define	SgpEndSymbol		10

#define SgpLastRequest		10
#define RgpFirstRequest		11

#define	RgpCombRaster		11
#define	RgpMoveRaster		12
#define	RgpWriteRaster		13

#define RgpLastRequest		13
#define OsiLastRequest		13

/* Byte swapping directions, into or outof the Display Server */
#define INTO	0
#define OUTOF	1

/* Raster combining function bit definitions
 *           SPD   S - source bit, P - pattern bit, D - destination bit */
#define FUNC_000 0x01
#define FUNC_001 0x02
#define FUNC_010 0x04
#define FUNC_011 0x08
#define FUNC_100 0x10
#define FUNC_101 0x20
#define FUNC_110 0x40
#define FUNC_111 0x80
#define FUNC_S	 0xF0
#define FUNC_P	 0xCC
#define FUNC_D	 0xAA
#define MAX_UNSIGNED_SHORT 0xFFFF

/* And some common combining functions */

#define FUNC_SET	0xFF
#define FUNC_CLEAR	0x00
#define FUNC_AND	( FUNC_S & FUNC_P ) & FUNC_D
#define FUNC_OR		( FUNC_S | FUNC_P ) | FUNC_D
#define FUNC_XOR	( FUNC_S ^ FUNC_P ) ^ FUNC_D
#define FUNC_SP_MASK	FUNC_S & FUNC_P
#define FUNC_S_INVERT	~ FUNC_S
#define FUNC_D_INVERT	~ FUNC_D
#define FUNC_SP_AND	FUNC_S & FUNC_P
#define FUNC_SP_OR	FUNC_S | FUNC_P
#define FUNC_SP_XOR	FUNC_S ^ FUNC_P
#define FUNC_SD_AND	FUNC_S & FUNC_D
#define FUNC_SD_OR	FUNC_S | FUNC_D
#define FUNC_SD_XOR	FUNC_S ^ FUNC_D

/* modify and query output state operations: */

#define OUTPUT_MODE	0x00000001 /* modify and query, int of mode bits */
#define READ_POSITION	0x00000002 /* modify and query,
					* text files:
					*   start x & y, stop x & y
					* raster files:
					*   start x & y, stop x & y
					* graphics files:
					*   symbol name (number) */
#define FILE_INFO	0x00000004 /* query, file type, zoomable, writer */
#define FILE_SIZE	0x00000008 /* query,
					* text files:
					*   min x & y, max x & y
					* raster files:
					*   min x & y, max x & y
					* graphics files: n/a */

/* misc */

#define STIPPLE_OFFSET	14
#define MaxCoord 32767
#define DISPLAY_SERVER		LDISPLAY_SERVER_GROUP
#define TextViewWidth( w ) 	(( w + 1 )*8 + 10 )
#define TextViewHeight( h )	( h*16 + 24 )


/* usage type bits */

#define UNUSED			0
#define ZOOMABLE		4 /* allow zoom */

#define MIN_ZOOM		-5
#define MAX_ZOOM		 5
/*
 * This bits go into type data field for Outline items
 */

#define LeftEdge 		1
#define RightEdge 		2
#define TopEdge 		4
#define BottomEdge 		8

#define AllEdges		( LeftEdge + RightEdge + TopEdge + BottomEdge )

/* request codes */

#define FIND_SELECTED_OBJECT	0x0001
#define INQUIRE_CALL		0x0002
#define INQUIRE_ITEM		0x1403
#define MODIFY_OUTPUT_STATE	0x1804
#define QUERY_OUTPUT_STATE	0x1405
#define REDRAW_FILE		0x2006

#define ds_CREATE_VIEW		0x1810
#define ds_CURSOR_UPDATE	0x0011
#define ds_DELETE_VIEW		0x0012
#define ds_DISPLAY_POPUP_MENU	0x1814
#define ds_DRAW_IN_BOTTOM	0x0015
#define ds_DRAW_ON_TOP		0x0016
#define ds_ERASE_POPUP_MENU	0x0017
#define ds_EXPANSION_DEPTH	0x0018
#define ds_FLASH_OUTLINE	0x0024
#define ds_GET_VGT_NAME		0x1434
#define ds_MOVE_VIEW		0x0041
#define ds_PAD_CURSOR_BLINK	0x0043
#define ds_PAD_CURSOR_OFF	0x0044
#define ds_PAD_CURSOR_ON	0x0045
#define ds_QUERY_DISPLAY_SERVER	0x0047
#define ds_REDRAW_MOVED_EDGES	0x0049
#define ds_REDRAW_SCREEN	0x2050
#define ds_SCREEN_DISABLE	0x0051
#define ds_SCREEN_ENABLE	0x0052
#define ds_SET_BANNER		0x1853
#define ds_SET_CURSOR		0x0056
#define ds_SET_GRAPHICS_FLAG	0x0057
#define ds_TIMER		0x0062
#define ds_VIEW_TOGGLE_GRID	0x0063
#define ds_ZOOM_IN		0x0064
#define ds_ZOOM_OUT		0x0065
#define ds_ZOOM_TO		0x0066

#define ds_UNBLOCK_FILE		0x0067
#define ds_RESET_FILE		0x0068
#define ds_VIEW_HIGHLIGHT	0x0069

/*
 * Types of items in the sdf
 */

#define SDF_MIN_TYPE		 1

#define SDF_SYMBOL_CALL 	 1
#define SDF_SYMBOL_DEF 		 2
#define SDF_FILLED_RECTANGLE 	 3
#define SDF_HORIZONTAL_LINE 	 4
#define SDF_VERTICAL_LINE 	 5
#define SDF_POINT 		 6
#define SDF_SIMPLE_TEXT 	 7
#define SDF_GENERAL_LINE 	 8
#define SDF_OUTLINE 		 9		
#define SDF_HORIZONTAL_REF 	10	
#define SDF_VERTICAL_REF 	11	
#define SDF_SEL_HORIZ_REF 	12	
#define SDF_SEL_VERT_REF 	13
#define SDF_TEXT 		14
#define SDF_RASTER 		15
#define SDF_SPLINE 		16

#define SDF_POLYMARKER 		17
#define SDF_POLYLINE 		18
#define SDF_FILL_AREA 		19
#define SDF_CIRCLE 		20
#define SDF_FILL_CIRCLE 	21
#define SDF_POLYARC 		22
#define SDF_FILL_POLYARC 	23

#define SDF_COMMENT		24

/* change this if you add any more attributes */

#define SDF_MAX_TYPE	 	24

/* unimplemented ...
#define SDF_FILL_PATTERN 	30
#define SDF_FILL_AREA_OPACITY 	31
#define SDF_FILL_BORDER_STYLE 	32
#define SDF_FILL_AREA_COLOR 	33
#define SDF_MARKER_TYPE 	34
#define SDF_MARKER_COLOR 	35
#define SDF_POLYLINE_COLOR 	36
#define SDF_TEXT_COLOR 		37
#define SDF_FONT_INDEX 		38
#define SDF_COLOR 		39
*/

/* attributes 240 and above are reserved for internal use */

/* Range limits for attribute indicies */
#define MAX_FILL_PATTERN_INDEX	64
#define MAX_MARKER_TYPE_INDEX	39
#define MAX_FONT_INDEX		20

/********** Search Types ***************/

#define All         		0
#define AllLines    		1
#define JustHoriz   		2
#define JustVerts   		3
#define JustRects   		4
#define JustSymbols 		5
#define JustText    		6
#define JustRefPt   		7
#define JustSplines 		8
#define JustRasters		9
#define JustTheRest		999

/*
 * values of type data field for Filled Rectangles
 */
#define NM 			0	/* Metal */
#define NP 			1	/* PolySilicon */
#define ND 			2	/* Diffusion */
#define NI 			3	/* Ion Implant */
#define NC 			4	/* contact cut */
#define NB 			5	/* Burried contact */
#define NG 			6	/* OverGlass cut */
#define NDP 			7	/* What are these??? - WIN */
#define NMP 			8	
#define NDM 			9
#define ZZ 			10
#define BLACK 			11	/* solid black */
#define GRAY 			12	/* half-tone gray */
#define HILIGHT 		13	/* unselectable highlights */

/*
 * Page unblocking constants.
 */

#define MODE_SCROLL	1
#define MODE_SKIP	2
#define UNIT_LINE	1
#define UNIT_PAGE	2
#define UNIT_END	3


typedef enum
  {
    viewCursor,
    zoomCursor,
    padCursor,
    execCursor,
    normalCursor
  } CursorType;

typedef enum
  {
    DisplayString,
    DisplayPageMessage
  } BannerState;

/*
 * message types
 */

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			requestcode;
    InstanceId			fileid;
#else  LITTLE_ENDIAN
    InstanceId			fileid;
    SystemCode			requestcode;
#endif LITTLE_ENDIAN
    unsigned			mode;
    unsigned			unit;
    unsigned			number;
    unsigned			fill[ 4 ];
  } BlockedFileReqMes;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			requestcode;
    unsigned short		filenameindex; /*First byte of filename used */
    unsigned short		type;	       /* The type of file to create */
    unsigned short		filemode;
    unsigned short		height, width; 
    unsigned char		fileType;
    char			fill0;
    short			fill1;
#else  LITTLE_ENDIAN
    unsigned short		filenameindex; /*First byte of filename used */
    SystemCode			requestcode;
    unsigned short		filemode;
    unsigned short		type;	       /* The type of file to create */
    unsigned short		width, height; 
    short			fill1;
    char			fill0;
    unsigned char		fileType;
#endif LITTLE_ENDIAN
    unsigned			fill2;
    ContextId			contextid; /* Context used to interpret name */
    char			*filename;
    unsigned			filenamelen;
  } CreateInstanceReqMes;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			requestcode;
    short			fileid;
#else LITTLE_ENDIAN
    short			fileid;
    SystemCode			requestcode;
#endif LITTLE_ENDIAN
    int				debugcode;
    unsigned			fill[6];
  } DebugServerRequest;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			requestcode;
    InstanceId			fileid;
    short			item;
    short			number;
    short			xmin, ymin, xmax, ymax;
    unsigned char		typedata;
    char			fill0;
    unsigned char		type;
    char			fill1;
#else  LITTLE_ENDIAN
    InstanceId			fileid;
    SystemCode			requestcode;
    short			number;
    short			item;
    short			ymin, xmin, ymax, xmax;
    char			fill1;
    unsigned char		type;
    char			fill0;
    unsigned char		typedata;
#endif LITTLE_ENDIAN
    unsigned			fill;
    char			*data;
    unsigned			dataSize;
  } DisplayItemReqMes;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			requestcode;
    InstanceId			fileid;
    short			item;
    short			type;
    short			sxmin, symin, sxmax, symax;
    short			wxmin, wymin;
    short			zoom;
    Boolean			showGrid;
    char			fill0;
#else  LITTLE_ENDIAN
    InstanceId			fileid;
    SystemCode			requestcode;
    short			type;
    short			item;
    short			symin, sxmin, symax, sxmax;
    short			wymin, wxmin;
    char			fill0;
    Boolean			showGrid;
    short			zoom;
#endif LITTLE_ENDIAN
    char			*name;
    unsigned			length;
  } DisplayViewReqMes;
 
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			requestcode;
    InstanceId			fileid;
    short			item;
    short			fill0;
#else  LITTLE_ENDIAN
    InstanceId			fileid;
    SystemCode			requestcode;
    short			fill0;
    short			item;
#endif LITTLE_ENDIAN
    unsigned			operation;
    unsigned			fill[ 3 ];
    ModeDataType		*data;
    unsigned			dataSize;
  } DisplayStateReqMes;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    short			view;
    short			depth;
    short			fill0;
#else  LITTLE_ENDIAN
    short			view;
    SystemCode			code;
    short			fill0;
    short			depth;
#endif LITTLE_ENDIAN
    unsigned			fill[ 6 ];
  } ExpansionDepthReqMes;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			requestcode;
    InstanceId			fileid;
    short			xHit;
    short			yHit;
    short			searchType;
    short			numElements;
    short			item;
    short			edgeSet;
#else  LITTLE_ENDIAN
    InstanceId			fileid;
    SystemCode			requestcode;
    short			yHit;
    short			xHit;
    short			numElements;
    short			searchType;
    short			edgeSet;
    short			item;
#endif LITTLE_ENDIAN
    unsigned			fill[ 4 ];
  } FindObjectReqMes;

#ifdef goes_away
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    short			x;
    short			y;
    Boolean			edgeFlag;
    char			fill0;
#else  LITTLE_ENDIAN
    short			x;
    SystemCode			code;
    char			fill0;
    Boolean			edgeFlag;
    short			y;
#endif LITTLE_ENDIAN
    unsigned			fill[ 6 ];
  } FindTopViewReqMes;
#endif goes_away

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode 			code;
    short			edges;
    short			xmin, xmax, ymin, ymax;
#else  LITTLE_ENDIAN
    short			edges;
    SystemCode 			code;
    short			xmax, xmin, ymax, ymin;
#endif LITTLE_ENDIAN
    unsigned			fill[ 5 ];
  } FlashOutlineReqMes;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    InstanceId			fileid;
#else  LITTLE_ENDIAN
    InstanceId			fileid;
    SystemCode			code;
#endif LITTLE_ENDIAN
    unsigned			fill[ 7 ];
  } GeneralFileReqMes;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    short			screenLimitX;
    short			screenLimitY;
    short			cursorHeight;
    short			cursorWidth;
    short			fontHeight;
    short			fontWidth;
    short			leftMargin;
    short			bottomMargin; 
    short			fill0;
#else  LITTLE_ENDIAN
    short			screenLimitX;
    SystemCode			code;
    short			cursorHeight;
    short			screenLimitY;
    short			fontHeight;
    short			cursorWidth;
    short			leftMargin;
    short			fontWidth;
    short			fill0;
    short			bottomMargin; 
#endif LITTLE_ENDIAN
    unsigned			fill[ 3 ];   
  } GeneralQueryReplyMes;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    short			view; 
#else  LITTLE_ENDIAN
    short			view; 
    SystemCode			code;
#endif LITTLE_ENDIAN
    unsigned			highlight;
    unsigned			fill[ 6 ];
  } GeneralWindowReqMes;

#ifdef goes_away
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    short			y;
    short			view;
    short			fill0;
#else  LITTLE_ENDIAN
    short			y;
    SystemCode			code;
    short			fill0;
    short			view;
#endif LITTLE_ENDIAN
    unsigned			fill[ 6 ];
  } InBannerReqMes;
#endif goes_away

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    short			view; 
    short			sxmin, sxmax, symin, symax,
    				oldXmin, oldXmax, oldYmin, oldYmax;
#else  LITTLE_ENDIAN
    short			view; 
    SystemCode			code;
    short			sxmax, sxmin, symax, symin,
    				oldXmax, oldXmin, oldYmax, oldYmin;
#endif LITTLE_ENDIAN
    unsigned			filler[ 3 ];
  } MoveViewReqMes;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    short			optionCount;
#else  LITTLE_ENDIAN
    short			optionCount;
    SystemCode			code;
#endif LITTLE_ENDIAN
    unsigned			fill[ 5 ];
    char 			*menuStart;
    unsigned			segmentSize;
  } PopUpMenuReqMes; 

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode 			code;
    short			fill0;
    short			xMenuStart, yMenuStart, BltWidth, BltHeight;
#else  LITTLE_ENDIAN
    short			fill0;
    SystemCode 			code;
    short			yMenuStart, xMenuStart, BltHeight, BltWidth;
#endif LITTLE_ENDIAN
    unsigned			fill[ 5 ];
  } PopUpReplyMes;
  
#ifdef goes_away
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    short			view;
    short			sXmin, sXmax, sYmin, sYmax, 
    				wXmin, wXmax, wYmin, wYmax;
#else  LITTLE_ENDIAN
    short			view;
    SystemCode			code;
    short			sXmax, sXmin, sYmax, sYmin, 
    				wXmax, wXmin, wYmax, wYmin;
#endif LITTLE_ENDIAN
    unsigned			fill[ 3 ];
  } QueryViewReplyMes;
#endif goes_away

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    short			view; 
    Boolean			stretch;
    char			fill0;
    short			edges;
    short			sxmin, sxmax, symin, symax,
    				oldXmin,oldXmax,oldYmin,oldYmax;
#else  LITTLE_ENDIAN
    short			view; 
    SystemCode			code;
    short			edges;
    char			fill0;
    Boolean			stretch;
    short			sxmax, sxmin, symax, symin,
    				oldXmax, oldXmin, oldYmax, oldYmin;
#endif LITTLE_ENDIAN
    unsigned			fill[ 2 ];
  } RedrawMovedEdgesReqMes;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    short			view;
#else  LITTLE_ENDIAN
    short			view;
    SystemCode			code;
#endif LITTLE_ENDIAN
    int				newValue;
    unsigned			fill[ 6 ];
  } SetValueReqMes;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    short			fill0;
#else  LITTLE_ENDIAN
    short			fill0;
    SystemCode			code;
#endif LITTLE_ENDIAN
    int				number;
    unsigned			fill[ 6 ];
  } ShortReplyMes;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    short			fill0;
#else  LITTLE_ENDIAN
    short			fill0;
    SystemCode			code;
#endif LITTLE_ENDIAN
    unsigned			fill[ 7 ];
  } SimpleReqMes;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    short			view;
#else  LITTLE_ENDIAN
    short			view;
    SystemCode			code;
#endif LITTLE_ENDIAN
    unsigned			fill[ 5 ];
    char			*string;
    unsigned			strLen;
  } WindowStringReqMes;

#ifdef goes_away
typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    short			x;
    short			y;
    short			view;
#else  LITTLE_ENDIAN
    short			x;
    SystemCode			code;
    short			view;
    short			y;
#endif LITTLE_ENDIAN
    unsigned			fill[ 6 ];
  } XYReplyMes;
#endif goes_away

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    short			x;
    short			y;
    short			fill0;
#else  LITTLE_ENDIAN
    short			x;
    SystemCode			code;
    short			fill0;
    short			y;
#endif LITTLE_ENDIAN
    unsigned			fill[ 6 ];
  } XYReqMes;

typedef struct
  {
#ifndef LITTLE_ENDIAN
    SystemCode			code;
    short			viewId;
    short			worldX;
    short			worldY;
#else  LITTLE_ENDIAN
    short			viewId;
    SystemCode			code;
    short			worldY;
    short			worldX;
#endif LITTLE_ENDIAN
    unsigned			fill[ 6 ];
  } ZoomReqMes;

#endif VDISPLAY
