/*
 * ftrans.c
 *
 * Courtesy of Eric Holstege at Caltech			Februrary 15, 1983
 *
 *  Expands filename containing ~ and :
 *  A word of the form ~username gets replaced by that user's login directory.
 *  A word of the form ~ gets replaced by the user's login directory.
 *  A word of the form var: gets replaced by the value if the environmental
 *      variable 'var'.
 *  The translation is not recursive.
 */
#include <pwd.h>

static char buf[2][256];
static int w = 1;

char *ftrans(file)
char *file;
{
    register char *ip,*op,*iwp,*owp,*p,*b;
    char t;
    extern char *getname(), *getran();

    b = buf[w=(w+1)%2];
    ip = iwp = file;
    op = owp = b;
    for (;;) {
	switch (*ip) {
	    case '\0':
		goto done;
	    case '~':
		ip++;
		iwp = ip; owp = op;
		for (;;) {
		    if (*ip=='/' || !*ip) break;
		    *op++ = *ip++;
		}
		t = *ip;
		*ip = '\0';
		p = getname(iwp);
		*ip = t;
		if (p==0) return(0);
		strcpy(owp,p);
		op = owp + strlen(p);
		break;
	    case '/':
		*op++ = *ip++;
		iwp = ip; owp = op;
		break;
	    case ':':
		*ip = '\0';
		p = getran(iwp);
		*ip++ = ':';
		if (p==0) return(0);
		strcpy(owp,p);
		op = owp + strlen(p);
		iwp = ip; owp = op;
		break;
	    default:
		*op++ = *ip++;
		break;
	}
    }
done:
    *op = '\0';
    return(b);
}

char *getname(s)
char *s;
{
    int i;
    register struct passwd *p;
    extern struct passwd *getpwuid(), *getpwnam();

    if (!*s) {
	i = getuid();
	p = getpwuid(i);
	if (p==0) return(0);
	return(p->pw_dir);
    }
    p = getpwnam(s);
    if (p==0) return(0);
    return(p->pw_dir);
}

char *getran(s)
char *s;
{
    register char *p;
    extern char *getenv();

    p = getenv(s);
    if (p==0) return(0);
    return(p);
}
