/*
 * rarpd.h
 *
 * Reverse Address Resolution Protocol server
 * Copyright (c) 1984 Stanford University.
 *
 * Common header file.
 *
 */

#include <sys/param.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <pup/puplib.h>
#include <pup/puppacket.h>
#include <pup/pupstatus.h>
#include <pup/pupnettab.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>

/*
 * Ethernet hardware address
 */
typedef uchar EtherAddr[6];
/* Note: a 3Mb Ethernet address will take up only the first byte. */

#define enet3AddrSize 1
#define enet10AddrSize 6

typedef enum
  {
    enet3,
    enet10
  } EnetType;

/*
 * An IP prototcol address
 */
typedef uchar IPAddr[4];

/*
 * Per-network data structure
 */
typedef struct
  {
	EtherAddr Hard_Addr;		/*Ethernet Hardware address*/
	IPAddr Soft_Addr;		/*IP protocol Logical Address*/
  } TabEnt;

typedef struct 
  {
    EnetType enetType; 		/* enet10 or enet3. */
    EtherAddr Our_Eth_Addr;	/* our Ethernet address (10 or 3Mbps) */
    IPAddr Our_IP_Addr;		/* our (32-bit) IP addr */

    TabEnt *Table;		/*  array of entries */
    int	Size;			/* number of entries in table
				   0..Size-1 */
    int	When_Checked;		/* time disk file last checked */
    int	When_Read;		/* time disk file last read in */

    int	Fid;			/* file id for this ether */
    char FileName[20];		/* corresponding (string) file name. */
    union DevParams DevP;
  } PerNet;


extern PerNet *FidMap[NOFILE];

extern int debug;
