/*
 * rarp10test.c
 *
 * test program for Reverse Address Resolution Protocol server
 * 10 Mbps Ethernet version.
 *
 * Copyright (c) 1984 Stanford University.
 *
 * HISTORY:
 *
 * 11 June 1984	Sally Ahnger	Stanford (Gregorio)
 *	- Created
 ****************************************************************
 *
 * This programs sends a request packet to the rarp server and waits forever
 * for a reply, then displays the response packet.
 *
 */

#include <sys/param.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <pup/puplib.h>
#include <pup/puppacket.h>
#include <pup/pupstatus.h>
#include <pup/pupnettab.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>


/* An Ethernet hardware address (10Mbps) */
typedef uchar EtherAddr[6];

/* An IP prototcol address */
typedef uchar IPAddr[4];

/* An ethernet addresss for broadcast */
EtherAddr EtherBroad = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

/*global variables*/
long etherfid;		/* ethernet file id mask, used in select */
int fid;		/* ethernet file id */
union DevParams devp;	/* used in read*/
EtherAddr Our_Ether_Addr;	/*our hardware address*/

main(argc, argv)
int argc; /*number of parameters*/
char **argv; /*array of parameters*/
{
	int nfound, readfds;	/*needed for the select */
	int notrecd;		/*flag to tell if the reply was received*/

	etherfid = 0;		/*mask for select to tell what nets are open*/
	
	OpenEthers();		/*returns etherfid, devp, Our_Ether_Addr*/

	printf("about to send packet\n");

	SendP();

	notrecd = 1;
	do {
	    printf("about to do the select\n");

	    readfds = etherfid;		/*save ethermask*/
	    nfound = select(NOFILE, &readfds, 0, 0, 0);

	    printf("returned from select\n");
	
	    EtherRead(&notrecd);

	} while (notrecd);
}


EtherRead(notrecd)
int *notrecd;	/*comes in true, set to false if reply packet received*/
{
	struct NetPacket packet;
	register struct ether_arp *RARPpkt;
	
	if (enreadquick(fid, &devp, &(packet.Pup)) != OK) {
	    return(0);
	}
	
	RARPpkt = (struct ether_arp *)&(packet.Pup);

	if (getshort(RARPpkt->arp_op) == RARPOP_REPLY) {
    	    printf("Received: ");
	    PrintRARPpkt(RARPpkt);
	    *notrecd = 0;
	}
	else {
	    *notrecd = 1;	/*not necessary*/
	}
}



SendP()
{
	struct NetPacket packet;
	register struct ether_arp *outap;
	
	outap = (struct ether_arp *)&(packet.Pup);

	/*fill in sizes, etc.*/
	outap->arp_hrd = makeshort(ARPHRD_ETHER);
	outap->arp_pro = makeshort(ETHERPUP_IPTYPE);
	outap->arp_hln = sizeof(EtherAddr);
	outap->arp_pln = sizeof(IPAddr);
	
	/*fill in reply opcode and source and target address*/
	outap->arp_op = makeshort(RARPOP_REQUEST);
	bcopy(Our_Ether_Addr, outap->arp_xsha, sizeof(EtherAddr));
	bcopy(Our_Ether_Addr, outap->arp_xtha, sizeof(EtherAddr));

	printf("Sent (request): ");
	PrintRARPpkt(outap);
	
	/* broadcast a request packet */
	enwrite(EtherBroad, makeshort(ETHERTYPE_RARPTYPE),
			fid, &devp, outap, sizeof(*outap));
}

OpenEthers()
{
	struct pupnettab *pnt;
	union PakFilter filter;

	if (setpupnettab() == 0) {
	    fprintf(stderr, "rarp10test: cannot open %s\n",
	    			PUPNETTAB);
	    exit(1);
	}
	
	while (pnt = getpupnettab()) {

	    printf("Trying to open %s, ", pnt->pnt_devname);
	    printf("\n");

	    fid = enopen(pnt->pnt_devname, &devp);
	    if (fid < 0) {
		continue;
	    }

	    if (devp.en.dp.end_dev_type != ENDT_10MB) {
	    	close(fid);
		printf("%s not a 10mb ethernet\n", pnt->pnt_devname);
		continue;
	    }

	    /*fill in our hw addr and etherfid*/
	    bcopy(devp.en.dp.end_addr, Our_Ether_Addr, sizeof(EtherAddr));
	    etherfid |= (1<<fid);
	    
	    efinit(&devp, &filter, 63, makeshort(ETHERTYPE_RARPTYPE));
	    ensetfilt(fid, &filter);
	    break;
	}
	endpupnettab();
}

PrintRARPpkt(ap)
struct ether_arp *ap;
{
	printf("RARP packet, OpCode %o\n", getshort(ap->arp_op));
	printf("Target Ethernet address: ");
	PrintXChar(ap->arp_xtha,sizeof(EtherAddr));
	printf("Target IP Address: ");
	PrintDChar(ap->arp_xtpa,sizeof(IPAddr));
	printf("Source_Eth_Addr: ");
	PrintXChar(ap->arp_xsha,sizeof(EtherAddr));
	printf("Source_IP_Addr: ");
	PrintDChar(ap->arp_xspa,sizeof(IPAddr));
}

PrintXChar(a,n)
register uchar *a;
int n;
/* prints an array a for n characters (as hexadecimal digits) with dots in
 * between.
 */
{
	register int i;
	for (i = 0; i < n; i++) {
	    printf("%x", *a++);
	    if (i < n-1)
	    	printf(".");
	}
	printf("\n");
}

PrintDChar(a,n)
register uchar *a;
int n;
/* prints an array a for n characters (as decimal digits) with dots in
 * between.
 */
{
	register int i;
	for (i = 0; i < n; i++) {
	    printf("%d", *a++);
	    if (i < n-1)
	    	printf(".");
	}
	printf("\n");
}

