/*
 * host.c
 *
 * Given a host name or address, prints all of the names and addresses
 * for that host.
 *
 * HISTORY:
 * 11 November 1983	Jeffrey Mogul	Stanford
 *	- Created.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

main(argc, argv)
int argc;
char **argv;
{
	if (argc <= 1) {	/* name of this host */
	    char ourname[256];
	    gethostname(ourname, sizeof(ourname));
	    process(ourname);
	    exit(0);
	}
	
	sethostent(1);		/* force the database to stay open */

	while (argc-- > 1) {
	    argv++;
	    process(argv[0]);
	}
	
	endhostent();
	
	exit(0);
}

process(hname)
char *hname;
{
	struct hostent *hep;
	char **aliasp;
	struct in_addr ia;
	
	hep = gethostbyname(hname);
	
	if (hep == 0) {	/* might be a host number */
	    
	    ia.s_addr = inet_addr(hname);
	    
	    if (ia.s_addr == -1) {
		printf("unknown host name: %s\n", hname);
		return;
	    }
	    
	    hep = gethostbyaddr(&ia, sizeof(ia), AF_INET);
	    
	    if (hep == 0) {
		printf("unknown host number: %s\n", hname);
		return;
	    }
	}
	
	/* found the entry, now print it */
	printf("%s", hep->h_name);
	
	aliasp = hep->h_aliases;
	while (*aliasp) {
	    printf(" %s", *aliasp);
	    aliasp++;
	}

	bcopy(hep->h_addr, (caddr_t)&ia, sizeof(ia));
	printf(": %s\n", inet_ntoa(ia));
}
