/*
 * CPARSE type management
 */

#include "defs.h"

/*
 * TYdefault - return a type node for the default type
 */
public Tnode TYdefault()
{
	Strace(3, printf("TYdefault\n"));
	return(TYname(Nlookup("int"), TNIL, TNIL));
}

/*
 * TYname - make type nodes and find types
 */
public Tnode TYname(n1, n2, n3)
Name n1, n2, n3;
{
	register Tnode retnode, nextnode;
	Name names[3];
	register Integer i;
	register Symbol sp;

	checkref(n1);
	names[0] = n1;
	names[1] = n2;
	names[2] = n3;

	retnode = Talloc(T_TYPE);
	nextnode = TNIL;

	for (i=0; i<3; i++) {
		if (names[i]==NNIL)
			break;
		Strace(2, printf("TYname %d %s\n", i, Nstring(names[i])));
		sp = Symlookup(names[i], 0, Curlevel);
		checkref(sp);
		assert(sp->s_class==STYPEDEF);
		if (nextnode==TNIL) {
			retnode->ty.symptr = sp;
			nextnode = retnode;
		} else {
			nextnode->T_sib = Talloc(T_TYPE);
			nextnode = nextnode->T_sib;
			nextnode->ty.symptr = sp;
		}
	}

	return(retnode);
}

/*
 * TYresolve - resolve complex type specs
 */
public Stype TYresolve(node)
Tnode node;
{
	register Integer i;
	Stype t[3];
	register Stype noun, adj, unsg;

	checkref(node);
	Strace(2, printf("TYresolve %s ",xTop(node)));
	/*
	 * Just return if node is struct, union, or enum.
	 * Must calculate type, since the node contains a pointer to
	 * the symbol table instead (for struct/union)
	 */
	if (node->T_op==T_STRUCT) {
		Strace(2, printf("%s=TSTRTY\n",Nstring(node->ty.symptr->s_name)));
		return(TSTRTY);
	} else if (node->T_op==T_UNION) {
		Strace(2, printf("%s=TUNIONTY\n",Nstring(node->ty.symptr->s_name)));
		return(TUNIONTY);
	} else if (node->T_op==T_ENUM) {
		Strace(2, printf("%s=TENUMTY\n",Nstring(node->ty.symptr->s_name)));
		return(TENUMTY);
	}

	if (node->T_op != T_TYPE)
		cerror("TYresolve non-type");

	/*
	 * nothing to do for single type
	 */
	if (node->T_sib==TNIL) {
		Strace(2, printf("%s=%s\n",Nstring(node->ty.symptr->s_name),xSymtype(node->ty.symptr->s_type)));
		return(node->ty.symptr->s_type);
	}

	t[0] = node->ty.symptr->s_type;
	t[1] = node->T_sib->ty.symptr->s_type;
	if (node->T_sib->T_sib != TNIL) {
		t[2] = node->T_sib->T_sib->ty.symptr->s_type;
		/* three's the max */
		if (node->T_sib->T_sib->T_sib != TNIL)
			goto bad;
	} else
		t[2] = TUNDEF;

	Strace(2, printf("%s,%s,%s=",xSymtype(t[0]),xSymtype(t[1]),xSymtype(t[2])));

	unsg = TINT;	/* or TUNSIGNED */
	noun = TUNDEF;	/* TINT, TCHAR, or TFLOAT */
	adj = TINT;	/* or TLONG or TSHORT */

	for (i=0; i<3; i++) {
		switch (t[i]) {
		case TUNDEF:
			continue;
		case TUNSIGNED:
			if (unsg != TINT) goto bad;
			unsg = TUNSIGNED;
			continue;
		case TLONG:
		case TSHORT:
			if (adj != TINT) goto bad;
			adj = t[i];
			continue;
		case TINT:
		case TCHAR:
		case TFLOAT:
			if (noun != TUNDEF) goto bad;
			noun = t[i];
			continue;
		default:
			goto bad;
		}
	}

	if (noun==TUNDEF)
		noun = TINT;
	else if (noun==TFLOAT) {
		if (unsg != TINT || adj==TSHORT)
			goto bad;
		return(adj==TLONG ? TDOUBLE : TFLOAT);
	} else if (noun==TCHAR && adj != TINT)
		goto bad;

	if (adj != TINT)
		noun = adj;

	if (unsg==TUNSIGNED)
		noun += (TUNSIGNED-TINT);

	Strace(2, printf("%s\n",xSymtype(noun)));
	return(noun);

   bad:
	Strace(2, printf("error\n"));
	uerror("illegal type combination");
	return(TINT);
}

/*
 * TYfix - fix up type and check for legality
 */
public Stype TYfix(ptype, class, location)
Stype ptype;
Sclass class;
Slocation location;
{
	register Stype t, type;
	register Integer mod1, mod2;

	type = ptype;
	Strace(2, printf("TYfix %s 0%o %s\n",xSymclass(class),type,xSymloc(location)));
	if (type==TUNDEF)
		return(type);
	if (mod2 = (type & TMASK)) {
		t = DECREF(type);
		while (mod1 = mod2, mod2 = (t & TMASK)) {
			if (mod1==TARY && mod2==TFTN) {
				uerror("illegal array of functions");
				type = 0;
			} else if (mod1==TFTN && (mod2==TARY || mod2==TFTN)) {
				uerror("function returns illegal type");
				type = 0;
			}
			t = DECREF(t);
		}
	}

	/*
	 * detect function arguments, watching for structure declarations
	 * beware of
	 *	f(x) struct { int a[10]; } *x; { ... }
	 * the danger is that "a" will become a pointer
	 */
	if (class==SNULL && Paramlevel
		&& (location==IN_UNION || location==IN_STRUCT))
			class = SPARAM;
	if (class==SPARAM || (class==SREGISTER && Paramlevel)) {
		if (type==TFLOAT)
			type = TDOUBLE;
		else if (ISARY(type)) {
			type += (TPTR-TARY);
		} else if (ISFTN(type)) {
			werror("a function is declared as an argument");
			type = INCREF(type);
		} else if (ISFLD(type)) {
			uerror("a bitfield is declared as an argument");
		}
	}

	if ((location==IN_UNION || location==IN_STRUCT) && ISFTN(type)) {
		uerror("function illegal in struct or union");
		type = INCREF(type);
	}

	Strace(2, printf("TYfix type 0%o -> 0%o\n", ptype, type));

	return(type);
}

/*
 * TYmerge - merge reference types of a symbol
 */
public Tnode TYmerge(node, type)
Tnode node;
Stype type;
{
	Tnode TYreduce();

	if (node==TNIL)
		cerror("TYmerge null node");

	Strace(2, printf("TYmerge %s: ",xSymtype(type)));
	node = TYreduce(node, type, 0);

	Strace(2, putchar('\n'));
	node->T_type = npTYadj(node->T_type);

	return(node);
}

/*
 * npTYadj - non-portable type adjustment
 */
private Stype npTYadj(type)
Stype type;
{
	switch (BTYPE(type)) {
	case TLONG:
		MODTYPE(type, TINT);
		break;
	case TULONG:
		MODTYPE(type, TUNSIGNED);
		break;
	}
	return(type);
}

/*
 * TYreduce - reduce references to a single type
 */
private Tnode TYreduce(node, type)
Tnode node;
Stype type;
{
	register Stype t;
	Tnode name, dp;

	if (node==TNIL)
		cerror("TYreduce fell off end of type");

	Strace(2, printf("%s,0%o ",xTop(node),type));
	if (node->T_op==T_NAME) {
		node->T_type = type;
		return(node);
	}

	t = INCREF(type);
	if (node->T_op==T_UCALL)
		t += (TFTN-TPTR);	/* make into a function call */
	else if (node->T_op==T_UARRAY) {
		t += (TARY-TPTR);	/* make into an array ref */
		/* finish reducing the type */
		name = TYreduce(node->T_son, t);
		/* make a new node to form a list of dimension nodes */
		dp = Talloc(T_DIM);
		dp->sz.dim = node->sz.dim;
		/* link it onto the front of the list */
		if (name->nm.dimptr)
			Tappend(name->nm.dimptr, dp);
		else
			name->nm.dimptr = dp;
		return(name);
	} else if (node->T_op==T_FIELD) {
		/* grab size and run */
		name = node->T_son;
		assert(name->T_op==T_NAME);
		dp = Talloc(T_DIM);
		dp->sz.dim = node->sz.dim;
		name->nm.dimptr = dp;
		name->T_type = t + (TFLD-TPTR);
		return(name);
	}
	return(TYreduce(node->T_son, t));
}
