/*
 * CPARSE syntax tree management
 */

#include "defs.h"

/*
 * Talloc - allocate new tree node
 */
public Tnode Talloc(op)
Ttype op;
{
	register Tnode t;

	t = (Tnode)malloc(sizeof(union Tnode));
	t->T_op = op;
	Ttrace(2, printf("Talloc(%s)\n",xTop(t)));
	/* these lists are treated specially--list.last points to end of list */
	if (op==T_DECLIST || op==T_STMTLIST)
		t->list.last = TNIL;
	t->T_sib = TNIL;
	t->T_son = TNIL;
	t->T_type = TUNDEF;
	return(t);
}

/*
 * Tappend - append a node to another
 */
public Tappend(node1, node2)
Tnode node1;
register Tnode node2;
{
	register Tnode t = node1;

	if (node1==TNIL)
		return;
	/* if a list, take shortcut */
	if (t->T_op==T_DECLIST || t->T_op==T_STMTLIST) {
		Ttrace(2, printf("Tappend list\n"));
		if (t->list.last==TNIL)
			t->T_son = node2;
		else {
			if (t->list.last->T_sib != TNIL) {
				cerror("Tappend list overwrite\n");
			}
			t->list.last->T_sib = node2;
		}
		/* point to end of possible node chain just linked */
		while (node2->T_sib != TNIL)
			node2 = node2->T_sib;
		t->list.last = node2;
	} else {
		while (t->T_sib != TNIL)
			t = t->T_sib;
		Ttrace(2, printf("Tappend %s\n",xTop(node2)));
		t->T_sib = node2;
	}
}

/*
 * Tlastson - follow son pointers, return last one
 */
public Tnode Tlastson(n)
register Tnode n;
{
	if (n != TNIL) {
		while (n->T_son != TNIL)
			n = n->T_son;
	}
	return(n);
}

/*
 * Tinsert - insert a node
 */
public Tinsert(node1, node2)
Tnode node1, node2;
{
	Ttrace(2, printf("Tinsert\n"));
	if (node1==TNIL)
		return;
	if (node1->T_son != TNIL) cerror("Tinsert overwrite");
	node1->T_son = node2;
}

/*
 * Tlist - return a list node to group other nodes
 */
public Tnode Tlist(node)
Tnode node;
{
	register Tnode t;

	t = Talloc(T_DECLIST);
	t->T_son = node;
	t->list.last = node;
	return(t);
}

/*
 * Tblock - make a compound statement block
 *
 * decs should always be a T_DECLIST node
 */
public Tnode Tblock(decs, stmts)
Tnode decs, stmts;
{
	register Tnode t;

	Ttrace(2, printf("Tblock %s %s\n", xTop(decs), xTop(stmts)));
	t = Talloc(T_BLOCK);
	t->T_son = decs;
	t->T_son->T_sib = stmts;
	return(t);
}

/*
 * Tlabel - make a label node
 */
public Tnode Tlabel(node)
Tnode node;
{
	register Tnode t;

	Ttrace(2, printf("Tlabel %s\n", xTop(node)));
	t = Talloc(T_LABEL);
	t->T_son = node;
	return(t);
}

/*
 * Tfield - make a field type node
 */
public Tnode Tfield(node, width)
Tnode node, width;
{
	register Tnode t;

	Ttrace(2, printf("Tfield %s %s\n", xTop(node), xTop(width)));
	if (node->T_op != T_NAME) {
		uerror("illegal field type");
		/* pretend it never happened */
		return(node);
	}
		
	t = Talloc(T_FIELD);
	t->sz.dim = width;
	t->T_son = node;
	return(t);
}
