/*
 * CPARSE sruct/union handling
 */

#include "defs.h"

/*
 * Structinst - define a structure instance
 */
public Tnode Structinst(loc, name, decs)
Slocation loc;
Name name;
Tnode decs;
{
	void Structlist();
	register Tnode t, tt;
	register Symbol s;
	Stype stype = loc==IN_STRUCT ? TSTRTY : TUNIONTY;
	Sclass sclass = loc==IN_STRUCT ? SMOS : SMOU;

	/*
	 * make an entry in the symbol table, even if no name given
	 */
	if (name==NNIL)
		name = Nfakename();

	Strace(2, printf("Structinst of %s\n", Nstring(name)));

	/* get symbol pointer... if it already exists, Symdef will check it */
	s = Symlookup(name, S_STAG, Curlevel);
	if (s==SNIL) {
		s = Syminsert(name, sclass, Curlevel, true);
		s->s_flag = S_STAG;
	} else {
		if (s->s_type != stype) {
			uerror("redeclaration of %s", Nstring(name));
			/* just let it go for now */
		}
	}
	if (s->s_class==SNULL) {
		/* previous reference to this tag was not defined */
		s->s_class = sclass;
	}

	t = Talloc(T_SYM);
	t->sym.symptr = s;
	Symdef(t, loc==IN_STRUCT ? SSTNAME:SUNAME, stype, loc);

	/* process the member declarations */
	if (decs != TNIL)
		Structlist(decs, loc, sclass, s);

	tt = Talloc(loc==IN_STRUCT ? T_STRUCT : T_UNION);
	tt->T_son = t;
	tt->T_sib = decs;
	tt->ty.symptr = t->sym.symptr;

	return(tt);
}

/*
 * Structlist - process a list of structure member declarations
 */
private void Structlist(nodes, loc, class, tagptr)
Tnode nodes;
Slocation loc;
Sclass class;
Symbol tagptr;
{
	register Tnode dec, mnode, t;
	register Symbol s, sp;
	register Stype type, ttype;

	for (dec=nodes; dec != TNIL; dec = dec->T_sib) {
		/*
		 *	situation:	dec->	T_VARDEF
		 *				  /
		 *			      T_TYPEDEC-->T_????
		 *				/
		 *			    T_CLASS-->T_TYPE-->...
		 */
		type = TYresolve(dec->T_son->T_son->T_sib);

		for (mnode=dec->T_son->T_sib; mnode != TNIL; mnode=mnode->T_sib) {
			Strace(2, printf("Structlist op=%s\n",xTop(mnode)));

			t = TYmerge(mnode, type);
			if (t->nm.name==NNIL)
				continue;	/* null field spec */
			ttype = t->T_type;

			/*
			 * always masks any previous definitions
			 */
			s = Syminsert(t->nm.name, SMOS, Curlevel, false);
			s->s_szptr = t->nm.dimptr;

			if (tagptr->s_typtr==SNIL) {
				/* first member */
				tagptr->s_typtr = s;
			} else {
			   /*
			    * append new declaration at end of chain,
			    * since we have to traverse it to check for
			    * duplicates anyway
			    */
			   for (sp=tagptr->s_typtr; sp != SNIL; sp = sp->s_xlink) {
				if (sp->s_name==s->s_name)
					uerror("redeclaration of %s within same struct/union", Nstring(s->s_name));
				else if (sp->s_xlink==SNIL) {
					sp->s_xlink = s;
					break;
				}
			   }
			}

			Tmksym(t, s);
			Symdef(t, class, ttype, loc);
			t->sym.symptr->s_typtr = dec->T_son->T_son->T_sib->ty.symptr;
		}
	}
}

/*
 * Structsym - find struct/union symtab def entry
 */
public Symbol Structsym(term)
register Tnode term;
{
	register Symbol s;

	TTtrace(2, printf("Structsym %s (",xTop(term)));
	TTtrace(2, Stprint(term->T_type));
	TTtrace(2, printf(")\n"));

	/* quit if the expr type is not a struct/union type */
	if (BTYPE(term->T_type) != TSTRTY && BTYPE(term->T_type) != TUNIONTY) {
		uerror("illegal structure ref");
		return(SNIL);
	}

	switch (term->T_op) {
	case T_BINOP:
		/* recurse down the side that is a structure ptr type */
		if (BTYPE(term->T_son->T_type)==TSTRTY
		    || BTYPE(term->T_son->T_type)==TUNIONTY)
			return(Structsym(term->T_son));
		else
			return(Structsym(term->T_son->T_sib));
	case T_UNOP:
	case T_INCPRE:
	case T_INCPOST:
	case T_ARYREF:
	case T_UCALL:
		return(Structsym(term->T_son));
	case T_STREF:
		return(Structsym(term->T_son->T_sib));
	case T_CAST:
		/* typecasts have a pointer to the struct/union def */
		return(term->T_son->T_sib->ty.symptr);
	case T_SYM:
		/* must follow a symptr back to find the struct/union def */
		for (s=term->sym.symptr; s != SNIL; s = s->s_typtr)
			if (s->s_class==SSTNAME || s->s_class==SUNAME)
				break;
		return(s);
	case T_COND:
		if (BTYPE(term->T_son->T_sib->T_type)==TSTRTY
		    || BTYPE(term->T_son->T_sib->T_type)==TUNIONTY)
			return(Structsym(term->T_son->T_sib));
		else
			return(Structsym(term->T_son->T_sib->T_sib));
	default:
		cerror("oddball struct/union expr");
	}
	return(SNIL);
}
