/*
 * CPARSE statement node handling
 */

#include "defs.h"

/*
 * Stmt_if - make an if statement node
 */
public Tnode Stmt_if(expr, thenpart, elsepart)
Tnode expr, thenpart, elsepart;
{
	register Tnode t;

	t = Talloc(T_IF);
	expr->T_sib = thenpart;
	thenpart->T_sib = elsepart;
	t->T_son = expr;
	return(t);
}

/*
 * Stmt_while - make a while statement node
 */
public Tnode Stmt_while(expr, stmt)
Tnode expr, stmt;
{
	register Tnode t;

	LoopDepth--;
	t = Talloc(T_WHILE);
	expr->T_sib = stmt;
	t->T_son = expr;
	return(t);
}

/*
 * Stmt_do - make a do...while statement node
 */
public Tnode Stmt_do(expr, stmt)
Tnode expr, stmt;
{
	register Tnode t;

	LoopDepth--;
	t = Talloc(T_DO);
	expr->T_sib = stmt;
	t->T_son = expr;
	return(t);
}

/*
 * Stmt_for - make a for statement node
 */
public Tnode Stmt_for(expr1, expr2, expr3, stmt)
Tnode expr1, expr2, expr3, stmt;
{
	register Tnode t;

	LoopDepth--;
	t = Talloc(T_FOR);
	expr1->T_sib = expr2;
	expr2->T_sib = expr3;
	expr3->T_sib = stmt;
	t->T_son = expr1;
	return(t);
}

/*
 * Stmt_switch - make a switch statement
 */
public Tnode Stmt_switch(expr, stmt)
Tnode expr, stmt;
{
	register Tnode t;

	SwitchDepth--;
	t = Talloc(T_SWITCH);
	expr->T_sib = stmt;
	t->T_son = expr;
	return(t);
}

/*
 * Stmt - process break, continue, and return statements
 */
public Tnode Stmt(op, expr)
Ttype op;
Tnode expr;
{
	register Tnode t;

	t = Talloc(op);
	t->T_son = expr;

	switch (op) {
	case T_BREAK:
	case T_CONTINUE:
		if (SwitchDepth==0 && LoopDepth==0)
			uerror("break or continue outside loop");
		break;
	case T_RETURN:
		/* check return value against Curfunction */
		break;
	}

	return(t);
}
