/*
 * CPARSE scoping level management
 */

#include "defs.h"

/*
 * Setlevel - set scoping level
 */
public void Setlevel(n)
{
	/* in case of error recovery, fix up the symbol table */
	if (Tracesym) printf("\nsetlevel %d\n", n);
	if (Curlevel > n)
		Symclear(n+1);

	Curlevel = n;
	if (Curlevel==0) {
		RetExpr = false;
		VAflag = 0;
	}
}

/*
 * Enterlevel - enter a scoping level
 */
public void Enterlevel()
{
	Curlevel++;
	if (Tracesym) printf("enterlevel %d\n", Curlevel);
}

/*
 * Exitlevel - leave a scoping level
 */
public void Exitlevel()
{
	if (Curlevel==2)
		Curlevel = 1;
	Symclear(Curlevel);
	Curlevel--;
}
