/*
 * CPARSE - keyword handling
 *
 * Alan Hastings 2/15/85
 */

#include "defs.h"
#include "y.tab.h"

#define KEYHSIZE	117
#define Keyhash(h, s)		\
	Strhash(h, s);		\
	h %= KEYHSIZE;

/*
 * reserved words, action codes and tokens
 */
private struct Keyword Keywords[] = {
	"asm",		AR_A,	0,		(Keyword)0,
	"auto",		AR_CL,	SAUTO,		(Keyword)0,
	"break",	AR_RW,	BREAK,		(Keyword)0,
	"char",		AR_TY,	TCHAR,		(Keyword)0,
	"case",		AR_RW,	CASE,		(Keyword)0,
	"continue",	AR_RW,	CONTINUE,	(Keyword)0,
	"double",	AR_TY,	TDOUBLE,	(Keyword)0,
	"default",	AR_RW,	DEFAULT,	(Keyword)0,
	"do",		AR_RW,	DO,		(Keyword)0,
	"extern",	AR_CL,	SEXTERN,	(Keyword)0,
	"else",		AR_RW,	ELSE,		(Keyword)0,
	"enum",		AR_E,	ENUM,		(Keyword)0,
	"for",		AR_RW,	FOR,		(Keyword)0,
	"float",	AR_TY,	TFLOAT,		(Keyword)0,
	"fortran",	AR_CL,	SFORTRAN,	(Keyword)0,
	"goto",		AR_RW,	GOTO,		(Keyword)0,
	"if",		AR_RW,	IF,		(Keyword)0,
	"int",		AR_TY,	TINT,		(Keyword)0,
	"long",		AR_TY,	TLONG,		(Keyword)0,
	"return",	AR_RW,	RETURN,		(Keyword)0,
	"register",	AR_CL,	SREGISTER,	(Keyword)0,
	"switch",	AR_RW,	SWITCH,		(Keyword)0,
	"struct",	AR_S,	0,		(Keyword)0,
	"sizeof",	AR_RW,	SIZEOF,		(Keyword)0,
	"short",	AR_TY,	TSHORT,		(Keyword)0,
	"static",	AR_CL,	SSTATIC,	(Keyword)0,
	"typedef",	AR_CL,	STYPEDEF,	(Keyword)0,
	"unsigned",	AR_TY,	TUNSIGNED,	(Keyword)0,
	"union",	AR_U,	0,		(Keyword)0,
	"void",		AR_TY,	TUNDEF,		(Keyword)0,
	"while",	AR_RW,	WHILE,		(Keyword)0,
	"",		0,	0,	/* to stop the search */
};

private Keyword Keyhtab[KEYHSIZE];

/*
 * Keyinit - initialize keyword table
 */
public Keyinit()
{
	register Keyword k;
	register Hashval hval;
	register Short i;
	register Name n;
	register Symbol s;

	/* initialze hash table to nulls */
	for (i=0; i < KEYHSIZE; i++)
		Keyhtab[i] = (Keyword)0;

	/* loop through static array to make hash table entries */
	for (k=Keywords; *k->k_name; k++) {
		/* insert types into symbol table */
		if (k->k_action==AR_TY) {
			n = Nlookup(k->k_name);
			s = Syminsert(n, STYPEDEF, 0, true);
			s->s_type = k->k_value;
		}
		Keyhash(hval, k->k_name);
		k->k_next = Keyhtab[hval];
		Keyhtab[hval] = k;
	}
}

/*
 * Keylook - find keyword
 */
public Keyword Keylook(s)
register String s;
{
	register Hashval hval;
	register Keyword k;

	/* hash and follow chain */
	Keyhash(hval, s);
	for (k = Keyhtab[hval]; k; k = k->k_next) {
		if (strcmp(s, k->k_name)==0) {
			return(k);
		}
	}

	return((Keyword)0);
}
