/*
 * CPARSE function management
 */

#include "defs.h"

/*
 * Funstart - function preliminaries
 */
public Tnode Funstart(att, fdec)
register Tnode att;
Tnode fdec;
{
	register Tnode fnode, t;
	Symbol s;
	Stype funtype, wholetype;

	assert(att->T_op==T_CLASS);
	assert(Globallevel);

	Strace(4, Tprint(fdec));
	/*
	 * define the function name
	 */
	funtype = TYresolve(att->T_sib);
	if (att->cl.class != SSTATIC)
		att->cl.class = SEXTDEF;

	fnode = TYmerge(fdec, funtype);
	wholetype = fnode->T_type;
	s = Symlookup(fnode->nm.name, 0, 0);
	if (s==SNIL)
		s = Syminsert(fnode->nm.name, att->cl.class, 0, true);
	Tmksym(fnode, s);
	Symdef(fnode, att->cl.class, wholetype, IN_OTHER);
	Curfunction = fnode->sym.symptr;
	Curfunction->s_line = Lineno;
	fnode->sym.symptr->s_typtr = att->T_sib->ty.symptr;
	Strace(3, printf("Funstart attach %s to type %s\n",Nstring(s->s_name),Nstring(att->T_sib->ty.symptr->s_name)));

	/*
	 * now enter level 1 and process arguments to function
	 */
	Enterlevel();
	LoopDepth = 0;		/* just in case */
	SwitchDepth = 0;

	/* args are found in sibling pointer */
	for (t=fnode->T_sib; t != TNIL; t = t->T_sib) {
		Strace(2, printf("func arg %s %s\n",xTop(t),Nstring(t->nm.name)));
		/* always hide previous definition of the symbol */
		s = Syminsert(t->nm.name, SPARAM, Curlevel, true);
		s->s_type = TINT;
		s->s_flag = S_FARG;
		Tmksym(t, s);
	}
	/* node returned is */
	t = Talloc(T_FUNARGS);
	t->T_son = att;
	t->T_sib = fdec;
	return(t);
}

/*
 * Funargs - process argument declarations
 */
public Tnode Funargs(att, declist)
register Tnode att;
Tnode declist;
{
	register Tnode t;

	assert(att->T_op==T_CLASS);
	assert(Paramlevel);

	Strace(2, printf("Funargs %s level=%d\n", xTop(declist), Curlevel));
	Syminst(att->cl.class, att->T_sib, declist, IN_OTHER);
	/* node returned is a type with names attached */
	return(Tmkvardef(att, declist));
}

/*
 * Fundec - paste together the nodes comprising a function
 *
 * the name and arguments have already been processed
 */
public Tnode Fundec(header, argdeclist, body)
Tnode header, argdeclist, body;
{
	register Tnode t, tt;

	t = Talloc(T_FUNDEF);
	tt = Talloc(T_FUNHEAD);
	t->T_son = tt;
	tt->T_son = header;
	tt->T_sib = argdeclist;
	tt->T_sib->T_sib = body;
	if (LintFlag)
		LintFun(header);
	return(t);
}

/*
 * Funcall - make a function call
 */
public Tnode Funcall(name, args)
Tnode name, args;
{
	register Tnode t;

	t = Talloc(T_UCALL);
	name->T_sib = args;
	t->T_son = name;
	t->T_type = name->T_type;
	return(t);
}

private char *LintTypes[] =
{
	"undef", "farg", "char", "short", "int", "long", "float",
	"double", "strty", "unionty", "enumty", "moety", "unsigned char",
	"unsigned short", "unsigned", "unsigned long"
};

/*
 * LintFun - print a lint-library summary of the function
 */
LintFun(header)
Tnode header;
{
	register Symbol s, fun;
	register Tnode t;
	String tname;
	Stype ttype;
	Boolean istypedef;

	/* find the symbol node for the function name */
	t = header->T_sib;
	while (t->T_op != T_SYM)
		t = t->T_son;
	fun = t->sym.symptr;

	/* don't print static functions */
	if (fun->s_class==SSTATIC)
		return;

	/* print varargs info first */
	if (VAflag != 0)
		printf("/* VARARGS%d */\n", VAflag-1);

	/* print the file and line number info as a comment */
	printf("/* # %d %s */\n", fun->s_line, Filename);

	if (fun->s_typtr==SNIL) {
		ttype = fun->s_type & BTMASK;
		tname = LintTypes[ttype];
		istypedef = true;
	} else {
		tname = Nstring(fun->s_typtr->s_name);
		ttype = fun->s_typtr->s_type;
		istypedef = fun->s_typtr->s_class==STYPEDEF ? true : false;
	}

	/* print the function definition */
	LintPrintSym(fun->s_type, Nstring(fun->s_name), ttype, tname, istypedef, t->T_sib);

	printf(" ");

	/* print definitions of args if not INT */
	for (t=t->T_sib; t != TNIL; t = t->T_sib) {
		s = t->sym.symptr;
		if (s->s_type != TINT) {
			if (s->s_typtr != SNIL) {
				ttype = s->s_typtr->s_type;
				tname = Nstring(s->s_typtr->s_name);
				istypedef = s->s_typtr->s_class==STYPEDEF ? true : false;
			} else {
				ttype = s->s_type & BTMASK;
				tname = LintTypes[ttype];
				istypedef = true;
			}
			LintPrintSym(s->s_type, Nstring(s->s_name), ttype, tname, istypedef, TNIL);
			printf("; ");
		}
	}

	if (RetExpr) {
		/* declare a fake return variable and return it */
		if (fun->s_typtr != SNIL) {
			ttype = fun->s_typtr->s_type;
			tname = Nstring(fun->s_typtr->s_name);
			istypedef = fun->s_typtr->s_class==STYPEDEF ? true : false;
		} else {
			ttype = fun->s_type & BTMASK;
			tname = LintTypes[ttype];
			istypedef = true;
		}
		printf("{ return (");
		LintPrintSym(DECREF(fun->s_type), "", ttype, tname, istypedef, TNIL);
		printf(")0; }\n");
	} else {
		/* no return value */
		printf("{ }\n");
	}
}

LintPrintSym(type, symname, typetype, typename, istypedef, args)
Stype type, typetype;
String typename, symname;
Boolean istypedef;
Tnode args;
{
	int tarray[14], ttarray[14];
	int *ary, *tary;
	Stype t;

	/* reverse the type for accessibility */
	ary = &tarray[13];
	*ary = 0;
	t = type;
	while (t & TMASK) {
		*--ary = (t & TMASK);
		t = DECREF(t);
	}
	tary = &ttarray[13];
	*tary = 0;
	t = typetype;
	while (t & TMASK) {
		*--tary = (t & TMASK);
		t = DECREF(t);
	}

	if (!istypedef) {
		switch (t & BTMASK) {
		case TSTRTY:
			printf("struct "); break;
		case TUNIONTY:
			printf("union "); break;
		case TENUMTY:
			printf("enum "); break;
		}
	}

	/* strip off redundant info (in case typename is a typedef) */
	while (*tary == *ary) {
		tary++;
		ary++;
	}

	printf("%s ", typename);

	LintTypeDecode(ary, symname, args);
}

LintTypeDecode(ary, symname, args)
int *ary;
char *symname;
Tnode args;
{
	while (*ary) {
		switch (*ary++) {
		case TFTN:
			if (*ary==TPTR) {
				printf("(");
				LintTypeDecode(ary, symname, TNIL);
				printf(")()");
			} else {
				LintTypeDecode(ary, symname, TNIL);
				printf("(");
				while (args != TNIL) {
					if (args->T_sib != TNIL)
						printf("%s,", Nstring(args->sym.symptr->s_name));
					else
						printf("%s", Nstring(args->sym.symptr->s_name));
					args = args->T_sib;
				}
				printf(")");
			}
			return;
		case TPTR:
			printf("*");
			break;
		case TARY:
			LintTypeDecode(ary, symname, args);
			printf("[]");
			return;
		default:
			cerror("oddball type -- 0x%x", *--ary);
			return;
		}
	}
	printf("%s", symname);
}
