/*
 * CPARSE parser definitions
 *
 * Alan Hastings 2/17/85
 */

/*
 * lexical values for operator terminals
 */
#define	DIV	60
#define	MOD	62
#define	LS	64
#define	RS	66
#define	DOT	68
#define	STREF	69
#define	NOT	76
#define	COMPL	77
#define	INCR	78
#define	DECR	79
#define	EQ	80
#define	NE	81
#define	LE	82
#define	LT	83
#define	GE	84
#define	GT	85

#define	OTSIZE	GT+1	/* size of vector of operator types and strings */

/*
 * operator types for type checking
 */
#define	UTYPE	004
#define	BITYPE	010
#define	TYFLG	016

#define LOGFLG	020
#define	ASGFLG	001

/*
 * operator operand actions
 */
#define	MINT	001	/* int */
#define	MDBI	002	/* int or double */
#define	MSTR	004	/* struct/union */
#define	MPTR	010	/* pointer */
#define	MPTI	020	/* pointer or int */
#define	MENU	040	/* enum or enum member */

/*
 * type checking actions
 */
#define	PUN	00002
#define	TYPL	00004
#define	TYPR	00010
#define	TYMATCH	00040
#define	LVAL	00100
#define	PTMATCH	02000
#define	OTHER	04000

/*
 * types - augmented by TPTR, TFTN, or TARY
 */
#define	TNULL		TPTR	/* pointer to UNDEF */
#define	TVOID		TFTN	/* function returning UNDEF (for void) */
#define	TUNDEF		000
#define	TFARG		001
#define	TCHAR		002
#define	TSHORT		003
#define	TINT		004
#define	TLONG		005
#define	TFLOAT		006
#define	TDOUBLE		007
#define	TSTRTY		010
#define	TUNIONTY	011
#define	TENUMTY		012
#define	TMOETY		013
#define	TUCHAR		014
#define	TUSHORT		015
#define	TUNSIGNED	016
#define	TULONG		017

/*
 * type modifiers
 */
#define	TPTR		0020
#define	TFTN		0040
#define	TARY		0060
#define	TFLD		0100

/*
 * type parsing stuff
 */
#define	TMASK		0160
#define	BTMASK		0017
#define	BTSHIFT		4
#define	TSHIFT		3

#define	BTYPE(x)	((x)&BTMASK)
#define	ISPTR(x)	(((x)&TMASK)==TPTR)
#define	ISFTN(x)	(((x)&TMASK)==TFTN)
#define	ISARY(x)	(((x)&TMASK)==TARY)
#define	ISFLD(x)	(((x)&TMASK)==TFLD)

#define	MODTYPE(x,y)	x = ((x)&~BTMASK) | (y)
#define	INCREF(x)	((((x)&~BTMASK)<<TSHIFT) | TPTR | ((x)&BTMASK))
#define	DECREF(x)	((((x)>>TSHIFT)&~BTMASK) | ((x)&BTMASK))

/*
 * token modifiers
 */
#define	ASG	1+
#define	UNARY	2+
#define	NOASG	(-1)+
#define	NOUNARY	(-2)+

/*
 * storage classes
 */
#define	SNULL		000
#define	SAUTO		001
#define	SEXTERN		002
#define	SSTATIC		003
#define	SREGISTER	004
#define	SEXTDEF		005
#define	SLABEL		006
#define	SULABEL		007
#define	SMOS		010
#define	SPARAM		011
#define	SSTNAME		012
#define	SMOU		013
#define	SUNAME		014
#define	STYPEDEF	015
#define	SFORTRAN	016
#define	SENAME		017
#define	SMOE		020
#define	SUFORTRAN	021
#define	SUSTATIC	022

/*
 * field size is or'ed into storage class
 */
#define	SFIELD		0100
#define	SFLDSIZ		077

/*
 * symbol flags
 */
#define	S_MOS		0001
#define	S_FARG		0002
#define	S_NONUNIQ	0040
#define	S_STAG		0100

/*
 * sizes
 */
#define	ARGINIT		32 
#define	AUTOINIT	0 
#define	SZCHAR		8
#define	SZINT		32
#define	SZFLOAT		32
#define	SZDOUBLE	64
#define	SZLONG		32
#define	SZSHORT		16
#define	SZPOINT		32
#define	ALCHAR		8
#define	ALINT		32
#define	ALFLOAT		32
#define	ALDOUBLE	32
#define	ALLONG		32
#define	ALSHORT		16
#define	ALPOINT		32
#define	ALSTRUCT	8
#define	ALSTACK		32 

/*
 * size in which constants are converted
 * should be long if feasable
 */
#define	CONSZ	long

/*
 * size in which offsets are kept
 * should be large enough to cover address space in bits
 */
#define	OFFSZ	long

/*
 * translation for character constants
 */
#define	CCTRANS(x)	x
#define	CHARCAST(x)	(char)(x)
#define	makecc(con,val,i)	con = (con<<8)|((val<<24)>>24); 

/*
 * reserved word actions
 */
#define	AR_TY	0	/* type word */
#define	AR_RW	1	/* simple reserved word */
#define	AR_CL	2	/* storage class word */
#define	AR_S	3	/* struct */
#define	AR_U	4	/* union */
#define	AR_E	5	/* enum */
#define	AR_A	6	/* asm */

#define	MAXERRORS	30	/* fatal error threshold */
