/*
 * CPARSE general macros
 *
 * Alan Hastings 2/14/85
 */

#define public
#define private static

#define assert(b) \
    if (!(b)) { \
	cerror("assertion failed at line %d in file %s", __LINE__, __FILE__); \
    }

#define checkref(p) \
    if (p == 0) { \
	cerror("reference through nil pointer at line %d in file %s", \
	    __LINE__, __FILE__); \
    }

#define new(type)	((type)malloc(sizeof(struct type)))
#define dispose(ptr)	free(ptr)
#define	strdup(s)	strcpy(malloc((unsigned)strlen(s)+1), s)
#define streq(s1, s2)	(strcmp(s1, s2)==0)

/*
 * general hash routine for strings
 */
#define Strhash(h, s)			\
	{ register char *_p;		\
	  h = 0;			\
	  for (_p=s; *_p!='\0'; _p++) {	\
		h = (h << 1) ^ (*_p);	\
	  }				\
	}

/*
 * hashing for pointers
 */
#define	Ptrhash(p)	(((unsigned)p) >> 2)

/*
 * tree operation macros
 */
#define	Tmksym(t, s)	(t)->in.t_op = T_SYM; (t)->sym.symptr = s

#define	Optype(o)	(Op_type[o]&TYFLG)
#define	Opasg(o)	(Op_type[o]&ASGFLG)
#define	Opstr(o)	(Op_str[o])

/*
 * error exit codes
 */
#define	CERROR 1	/* compiler's fault (probably) */
#define	UERROR 2	/* user's fault */

/*
 * debugging macros
 */
#define	Ltrace(stmt)		if (Tracelex) stmt
#define	Ttrace(level, stmt)	if (Tracetree >= level) stmt
#define	TTtrace(level, stmt)	if (Tracetype >= level) stmt
#define	Strace(level, stmt)	if (Tracesym >= level) stmt
#define Ptrace(level, stmt)	if (Tracepgm==level) stmt

#define	xSymtype(x)		xtypes[BTYPE(x)]
#define	xSymclass(x)		((x)&SFIELD) ? "SFIELD":xclass[x]
#define	xSymref(x)		xref[((x)>>4)&03]
#define	xSymloc(x)		xloc[(unsigned int)x]
#define	xTop(x)			(x)==TNIL?"TNIL":xtops[(unsigned int)(x)->in.t_op]
