/*
 * CPARSE external variable declarations
 *
 * Alan Hastings 2/14/85
 */

/*
 * YACC externs
 *
 * see also y.tab.h produced during grammar processing
 */
#ifdef	YYDEBUG
extern Integer		yydebug;	/* general verbose trace */
#endif	YYDEBUG
extern String		xtypes[], xclass[], xtops[], xloc[];

/*
 * tree building stuff
 */
extern Integer		Lastcon;	/* constant value just scanned */
extern Double		Dcon;		/* real constant just scanned */

/*
 * global file stuff
 */
extern Integer		Nerrors;	/* error count */
extern Lnum		Lineno;		/* line number for diagnostics */
extern String		Filename;	/* the current input filename */
extern String		Progname;	/* this program's name */
extern String		Version;	/* the current version id */

extern Tnode		Program;	/* root node pointer */

extern Integer		LoopDepth;	/* level of loop nesting */
extern Integer		SwitchDepth;	/* level of switch nesting */
extern Integer		Curlevel;	/* current scoping level */
extern Symbol		Curfunction;	/* current function symbol */
extern Boolean		RetExpr;	/* true if function returns an value */
#define			Globallevel	(Curlevel==0)
#define			Paramlevel	(Curlevel==1)
#define			Funclevel	(Curlevel > 1)

/*
 * global flags
 */
extern Boolean		Tracelex;	/* trace lexical analysis */
extern Boolean		Traceinit;	/* trace initialization */
extern Integer		Tracesym;	/* trace symbols */
extern Integer		Tracetree;	/* trace tree operations */
extern Integer		Tracetype;	/* trace typechecking */
extern Integer		Tracepgm;	/* trace syntax tree */
extern Boolean		LintFlag;	/* print lint library function def */

extern Integer		VAflag;		/* varargs flag, per function */

/*
 * operator type checking stuff
 */
extern unsigned Short Op_type[];	/* vector of operator types */
extern String Op_str[];			/* vector of operator name strings */

/*
 * function declarations
 */
String		strcpy();

Keyword		Keylook();
Integer		getopt();
Symbol		Symlookup(), Syminsert(), Structsym();
Name		Nlookup(), Nfakename();
String		Nstring();
Stype		TYresolve(), npTYadj();
void		Enterlevel(), Exitlevel(), Setlevel();
void		Opinit(), Optymatch(), Opptmatch();
void		Symclear(), Symdef(), Syminst();
unsigned short	Opaction(), Opmod();
Boolean		Oplval();

Tnode	Talloc(), Tlastson(), Symdec(), TYname(), Enuminst(), Structinst();
Tnode	Tmkumul(), Tmkarray(), Tmkvardef(), Funcall(), Fundec(), Funargs();
Tnode	Tmkname(), Tlabel(), Tlist(), Tblock(), TYmerge(), Funstart();
Tnode	Icon(), Fcon(), Scon(), Tfield();
Tnode	Stmt(), Stmt_if(), Stmt_while(), Stmt_do(), Stmt_for(), Stmt_switch();
Tnode	Tmkaryref(), Tmkassop(), Tmkbinop(), Tmkcast(), Tmkcmlist();
Tnode	Tmkcond(), Tmkfunsym(), Tmkgoto(), Tmkincop(), Tmklabel();
Tnode	Tmkopinc(), Tmksizeof(), Tmkstunref(), Tmkvaref(), Tmkunop();
Tnode	Tmkcastype();
