/*
 * vstart.c
 *
 * Start a V server on each ethernet interface
 *
 * Usage:
 *	vstart server-name [server options]
 *
 * For example, if /dev/enet and /dev/eneta exist,
 * running:
 *	vstart /etc/V/Vserver p
 * is the same as
 *	/etc/V/Vserver p /dev/enet&
 *	/etc/V/Vserver p /dev/eneta&
 * i.e., the device name becomes the last argument to the server program.
 *
 * HISTORY:
 * 14 March 1984	Jeff Mogul	Stanford [Coyote]
 *	- Created.
 */

#include <sys/param.h>
#include <sys/dir.h>
#include <errno.h>
#include <stdio.h>

extern int errno;

main(argc, argv)
int argc;
char **argv;
{
	char server_name[MAXPATHLEN];
	char *dev_name = 0;
	char *NextEnet();
	int i;

	if (argc < 2) {
	    Usage();
	    exit(1);
	}
	strcpy(server_name, argv[1]);
	
	/* re-use old argv */
	for (i = 0; i < (argc - 1); i++)
	    argv[i] = argv[i+1];
	
	FirstEnet();

	while (dev_name = NextEnet()) {
	    int fork_stat = vfork();
	    
	    if (fork_stat == 0) {
		argv[argc-1] = dev_name;	/* pass devname as last arg */
		execv(server_name, argv);
		perror(server_name);
		_exit(1);
	    }
	    
	    if (fork_stat < 0)
	    	perror("vstart: vfork() failed");
	}
	exit(0);
}

Usage()
{
	fprintf(stderr, "Usage: vstart server-name [server-options]\n");
}

#include <sys/file.h>

char *enet_names[] = {
	"/dev/enet0",
	"/dev/eneta0",
	"/dev/enetb0",
	"/dev/enetc0",
	"/dev/enetd0",
	"/dev/enete0",
	"/dev/enetf0",
	"/dev/enetg0",
	"/dev/eneth0",
};
#define	N_ENET_NAMES	(sizeof(enet_names)/sizeof(char *))
char enet_index;

FirstEnet()
{
	enet_index = 0;
}

char *NextEnet()
{
	static char this_name[sizeof(enet_names)];	/* conservative */
	int open_errno;
	int fid;
	
	while (enet_index < N_ENET_NAMES) {
	    strcpy(this_name, enet_names[enet_index++]);
	    
	    errno = 0;
	    fid = open(this_name, O_RDONLY);
	    open_errno = errno;
	    if (fid >= 0)
	    	close(fid);

	    switch (open_errno) {
		case	ENOENT:	/* filename does not exist */
		case	ENXIO:	/* no underlying char device */
			continue;

		case	EBUSY:	/* already open */
		case	0:	/* open succeeded */
			/* we need to strip off the trailing 0 */
			this_name[strlen(this_name) - 1] = 0;
			return(this_name);

		default:
			perror(this_name);
			continue;
	    }
	}

	return(0);
}
