/*
 * filtpri.h
 *
 * "Recommended" priorities for the enet packet filter
 *
 * Part of the Pup (library but probably shouldn't be.)
 *
 * HISTORY:
 * 24 October 1984	Jeff Mogul	Stanford
 *	- Created.
 ****************************************************************
 *
 * The basic idea is to assign priorities so that (in order)
 *	(1) packets which MUST be delivered to a particular program
 *		go to the highest priority filter
 *	(2) programs that are more likely to accept a received
 *		packet have relatively high priorities
 *	(3) programs that have roughly equal characteristics get
 *		the same priority so that the driver can order
 *		them dynamically.
 *	(4) programs that never accept packets use the lowest priority.
 *
 *	Based on packet counts & intuition, we break programs down
 *	into 5 groups, in order of decreasing priority:
 *
 *	Pup gateway		Must be checked first
 *
 *	BSP connection		Active data transfers, so likely to
 *	V session			accept packets
 *
 *	GatewayInfo		Receive frequent broadcasts
 *	MiscServer
 *
 *	BSP listener		Receive infrequent requests
 *	V listener
 *
 *	BreathLife		Never accepts a packet
 *
 *	Placing the leaf server in this spectrum is problematic, but
 *	since it uses a single filter for both listener and connection
 *	it should probably be placed in the same group as the BSP
 *	and V listeners, since most of the time it is going to be idle.
 *
 *	Programs/subroutines that send broadcast request and wait for
 *	(potentially many) answers should go near MiscServer in priority.
 *	However, because they are short-lived, they will always have low
 *	packet counts and so should not use the same priority as MiscServer;
 *	that would result in unnecessary queue reordering in the driver.
 */

#define	ENFP_MAX	255	/* should get this from enetdefs.h */
#define	ENFP_MIN	0

#define	ENFP_SESSION	127	/* for active sessions */
#define	ENFP_BCSERVE	64	/* broadcast servers */
#define	ENFP_LISTEN	32	/* listeners */

/*
 * Recommended priorities for specific applications
 */
#define	ENFP_GATEWAY	ENFP_MAX
#define	ENFP_BSPSESSION	ENFP_SESSION
#define	ENFP_VSESSION	ENFP_SESSION
#define	ENFP_EFTP	ENFP_SESSION
#define	ENFP_GWINFO	ENFP_BCSERVE
#define	ENFP_MISCSRV	ENFP_BCSERVE
#define	ENFP_LOOKUP	(ENFP_BCSERVE - 1)	/* for broadcast lookups */
#define	ENFP_BSPLISTEN	ENFP_LISTEN
#define	ENFP_VLISTEN	ENFP_LISTEN
#define	ENFP_LEAF	ENFP_LISTEN
#define	ENFP_BREATHLIFE	ENFP_MIN
