/*
 *  - change to kernel mode (the MicroVAX bootstrap leaves the
 *    machine executing on the interrupt stack)
 *  - clear "boot in progress" flag (otherwise sundries such as
 *    auto reboot and halt don't behave as expected).
 *  - use #include (to get microVAX architecture definitions)
 *    and #ifdef   (to generate multiple versions of crt0).
 *    NOTE: this code must be preprocessed by cpp.
 */

#include "mvax.hs"

	.text
	.globl	start		/* Normal entry point for program after boot*/

/* External symbols: */
#ifdef XDELTA
	.globl	_dbg$init
	.globl	_dbg$break
	.globl	_xdt$fault
#endif XDELTA
#ifdef INITINTS
	.globl	_initints
#endif INITINTS



#ifdef XDELTA
	.globl	restart		/* A hook for debugging sessions that bomb  */
restart:			/* Put this at the start so it has an easily*/
				/* remembered address (probably 0xa000)     */
	jmp	_xdt$fault
#endif XDELTA

start:
	moval	_end+8192,sp
	movl	sp,fp		/* FP is not initialized by mVAX bootstrap  */
	
	/* If we're on the interrupt stack then change to the kernel stack  */
	movpsl	-(sp)
	bbcc	$(psl$v_is % 8), (psl$v_is / 8)(sp), not_i
	pushal	chm_done	/* Build a fake REI frame ("saved" PSL, PC) */
	moval	8(sp), r0	/* Initialize the Kernel Stack Pointer;	    */
	mtpr	r0, $ksp	/*   value = (value of SP at chm_not_i)	    */
	rei			/* REI:  mode = kernel, jumps to chm_done   */
not_i:
	addl2	$4,sp		/* get rid pushed psl */
chm_done:
	moval	_end+8192,sp
	movl	sp,fp		/* FP is not initialized by mVAX bootstrap  */

	mtpr	$txdb_clear_boot_flag, $txdb
#ifdef INITINTS
	calls	$0,_initints	
#endif INITINTS
#ifdef XDELTA
	mfpr	$scbb, -(sp)	/* dbg$init(scbb) - note that we use the SCB*/
	calls	$1, _dbg$init	/*  provided by the bootstrap, not xdelta's */
	jsb	_dbg$break	/* Execute a breakpoint before starting Vsasu*/
#endif XDELTA
				/* Push arguments for _Vsasu:		    */
	pushl	r11		/*   arge = addr of Restart Parameter Block */
	pushal	4(ap)		/*   argv = bootstrap argument list	    */
	movzwl	(ap), -(sp)	/*   argc = length of argument list	    */
	calls	$3, _Vsasu
#ifdef XDELTA
	jsb	_dbg$break	/* And another breakpoint before halting    */
#endif XDELTA
	halt

/*
*	The exit routine.  Prints the exit status and then halts or
*	goes into the debugger.
*/
	.text
	.align	1
	.globl	_exit
_exit:
	.word	0x0
	.data
L44:
	.ascii	"Exited with a status of %d\0"
	.text
	pushl	4(ap)
	pushl	$L44
	calls	$2,_printf
#ifdef XDELTA
	jsb	_dbg$break
#endif XDELTA
	halt
