/*
 * Miscellaneous junk for the V I/O protocol boot loader
 */

#include <Venviron.h>
#include <Vnaming.h>
#include <Vsession.h>



PutShortHex(i)
  {
    K_putchar(MakeHexDigit(i>>12));
    K_putchar(MakeHexDigit(i>>8));
    K_putchar(MakeHexDigit(i>>4));
    K_putchar(MakeHexDigit(i));
  }

MakeHexDigit(i)
    register int i;
  {
    i &= 0xF;
    if (i >= 10) 
	i += ('a' - 10);
    else
	i += '0';
    return (i);
  }



CopyBytes( dest, src, bytes ) register char *dest, *src;
                    register short bytes;
  /* Small but slow version */
  {
    if (bytes--) do
      {
	*dest++ = *src++;
      }
    while(--bytes != -1);
  }
