
#include <Vio.h>

static PerProcessArea PPA;
PerProcessArea *PerProcess = &PPA;

ProcessId Kernel_Process_Pid = 0xffffffff;

static EchoFlag = 1;

NoEcho()
  {
    EchoFlag = 0;
  }
  
Echo()
  {
    EchoFlag = 1;
  }

int IsEcho()
  {
    return(EchoFlag);
  }

static CookedFlag = 1;

Cooked()
  {
    CookedFlag = 1;
  }
  
Raw()
  {
    CookedFlag = 0;
  }

int IsCooked()
  {
    return(CookedFlag);
  }

RawGetchar()
  {
    char c;
    
    while ((c = K_mayget()) == -1);
    if (EchoFlag)
	K_putchar(c);
    if (c == '\r')
      {
	c = '\n';
	if (EchoFlag)
	    K_putchar(c);
      }
    return(c);
  }

static BufferIndex = 0;
static BufferCount = 0;
static char Buffer[128];

#define control(c) (c & 0x1f)

GetBufferedLine()
  {
    char c = 0;
    
    BufferCount = 0;

    while (c != '\n')
      {
        c = RawGetchar();
        switch(c)
	  {
	case control('H'):
	case 0x7f:
		if (BufferCount)
		  {
		    BufferCount--;
		    if (EchoFlag)
		      {
		        if (c == 0x7f)
			    K_putchar(control('H'));
		        K_putchar(' ');
			K_putchar(control('H'));
		      }
		  }
		else
		    if (c == control('H'))
		        K_putchar(' ');
		break;
	case control('U'):
		for (; BufferCount; BufferCount--)
		    if (EchoFlag)
		      {
		        K_putchar(control('H'));
			K_putchar(' ');
			K_putchar(control('H'));
		      }
		break;
	default:
		Buffer[BufferCount++] = c;
		break;
	  }
      }
	
    BufferIndex = 0;
  }


unsigned OldFillBuffer( fad )  register File *fad;

   /* Fill the buffer of the open file specified by fad. Return the first
    * character in the buffer or EOF.
    */

   {
      if( fad->state & EOF_BYTE )   return( EOF );

      if ((fad == stdin) && (stdout->type & INTERACTIVE))
	Flush(stdout); /* Flush standard output */

   /* If all the bytes returned in the last call to Read have been read,
    * move to the next block.
    */

      if( fad->readindex == fad->bytes && fad->type & VARIABLE_BLOCK )
        fad->readindex = fad->blocksize;

   /* Normalize the current byte position, put the file in reading mode,
    * and return the first character read or EOF.
    */

      Seek( fad, 0, REL_BYTE );

      if( fad->readindex < fad->bytes )
        return( fad->buffer[ fad->readindex++] );
      
      fad->state |= EOF_BYTE;
      return( EOF );
   }

unsigned FillBuffer(fad)
File *fad;
  {
    char c;

    if (fad == stdin)
      {
        if (BufferIndex < BufferCount)
	    return(Buffer[BufferIndex++]);
	if (CookedFlag)
	  {
	    GetBufferedLine();
	    return(Buffer[BufferIndex++]);
	  }
	return(RawGetchar());
      }
    
    return(OldFillBuffer(fad));
  }

OldFlushBuffer( fad, byte)  register File *fad; char byte;
 
    /* Flush the buffer of the open file specified by fad, and put the
     * byte in the now empty buffer.
     */
 
  {
    if( fad->state & EOF_BYTE )  return ( EOF );
 
    Seek( fad, 0, REL_BYTE );
    fad->block = fad->tempblock;
    fad->readindex = MAXUNSIGNED;

    if( (fad->writeindex = fad->tempindex) < fad->blocksize )
        return( fad->buffer[ fad->writeindex++ ] = byte );

    fad->state |= EOF_BYTE; 
    return( EOF );
  }

FlushBuffer(fad, byte)
File *fad;
char byte;
  {
    if (fad == stdout || fad == stderr)
      return(K_putchar(byte));
    
   return( OldFlushBuffer(fad, byte) );
  }
