/* Standalone local context routines */

char CurrentSession[80] = "";

/*
 * directcurctx.c
 * DirectToCurrentContext directs a request to the current context, or to
 *   the local name server if it begins with a square bracket ('[').
 *   The function returns the pid to which the request should be sent,
 *   and puts the proper context id in the contextid field of the message.
 *   This is written as a function to avoid duplicating the code that
 *   knows about square brackets all over the place.
 *
 * Tim Mann 8-26-83
 * Hacked up for standalone Joe Pallas 7-12-84
 */

#include "Vnaming.h"
#include "Vioprotocol.h"

InstanceId SessionInstance;

ProcessId DirectToCurrentContext(request)
    register NameRequest *request;
  {
    char *index(), *close, session[80], name[40], pass[40], idstring[80];
    int length;
    ProcessId pid;
    SystemCode err;
    int cooked, echo;
    
    /* if the name begins with a '[', check if the name is the one we have
     * registered.  If it isn't, log out the old session (if there is one)
     * and log in a new one, prompting for user name and password.  This
     * becomes the new current context.  Otherwise, just use the current
     * context.
     */ 

    if (request->nameptr[request->nameindex] == '[')
      {
	if ((close = index(request->nameptr+request->nameindex, ']')) == NULL)
	    return(0);
	session[0] = '\0'; /* Use this and strncat, not strncpy, because */
			   /*   the latter may not write a final \0      */
	strncat(session, request->nameptr+request->nameindex+1,
		close - (request->nameptr+request->nameindex+1) );
#ifdef SESSION_LIVES
	if (strcmp(session, CurrentSession) != 0)
#endif SESSION_LIVES
	  {
	    /* do all that logging out and in stuff */
	    Message msg;
	    ProcessId newpid = LookupSession(session, &err);
	    if (newpid == 0)
	      {
		printf("Name lookup: %s\n", ErrorString(err));
	        return(0);
	      }
#ifdef SESSION_LIVES
#define irequest ((IoRequest *) msg)
#define ireply ((IoReply *) msg)
	    irequest->requestcode = RELEASE_INSTANCE;
	    irequest->fileid = SessionInstance;
	    irequest->releasemode = OK;
	    if (PerProcess->nameserver)		/* don't bother if null */
		Send(irequest, PerProcess->nameserver);
	    /* ignore the return code */
#endif SESSION_LIVES
	    cooked = IsCooked();
	    echo = IsEcho();
	    Cooked();
	    Echo();
    	    printf("User name: ");
	    gets(name);
	    NoEcho();
	    printf("Password: ");
	    gets(pass);
	    printf("\n");
	    if (echo) Echo();
	    if (!cooked) Raw();
	    length = strlen(name);
	    strcpy(idstring, name);
	    strcpy(idstring+length+1, pass);
	    length += strlen(pass) + 1;
	    CreateSessionProcess(idstring, length, 0, newpid,
	    	&PerProcess->nameserver, &SessionInstance, &err);
	    PerProcess->contextid = LOGIN_CONTEXT;
	    if (err != OK)
	      {
	        printf("Error logging in: %s", ErrorString(err));
		strcpy(CurrentSession, "");
		return(0);
	      }
	    strcpy(CurrentSession, session);
	  }
	/* now strip off the leading [name] */
	request->nameindex = close + 1 - request->nameptr;
      }
    else
      {
#ifdef SESSION_LIVES
        if (PerProcess->nameserver == 0)
#endif SESSION_LIVES
	  {
	    Message msg;
	    NameRequest *fakemsg = (NameRequest *)msg;
	    char host[40], fakename[42];
	    
	    cooked = IsCooked();
	    echo = IsEcho();
	    Cooked();
	    Echo();
	    printf("Host name: ");
	    gets(host);
	    if (!cooked) Raw();
	    if (!echo) NoEcho();
	    /* fake a message */
	    sprintf(fakename, "[%s]", host);
	    fakemsg->nameptr = fakename;
	    fakemsg->nameindex = 0;
	    DirectToCurrentContext(fakemsg);
	  }
      }  
    request->namecontextid = PerProcess->contextid;
    return( PerProcess->nameserver );
  }
