/*
 * Distributed V Kernel
 * Copyright (c) 1982 by David Cheriton, Willy Zwaenepoel
 *
 * Kernel Ethernet driver
 * Sun 3 Mbit version, hacked into a busy-wait driver
 *   for use in bootloading
 */

#include "Venviron.h"
#include "Vethernet.h"
#include "Vikc.h"

#include "enet3.h"
#include "process.h"

#define WORDS_PER_PACKET (sizeof(kPacket)/2+2)
			/* control words in a kernel packet */
#define MAXLOOPCOUNT 200000

#ifdef DEBUG
#define debug(c) K_putchar(c)
#else
#define debug(c)
#endif DEBUG

/* Exports */
extern SystemCode EnetPowerup();
extern SystemCode AwaitKernelPacket();
extern int WriteKernelPacket();
int KernelPacketType = V_KERNEL_PACKET;
char HexEnetAddress[sizeof(NetAddress)*2 + 1];

/* Private */
SystemCode ReadChecksum();

NetAddress	EnetHostNumber;		/* physical ethernet address */
short		EnetStatus;		/* Current status settings */
char		kPacketArea[sizeof(kPacket)+4]; /* 4 bytes for net header */
					/* Save area for kernel packets */
EnetBlock	*EnetPacket  = (EnetBlock *) kPacketArea;
kPacket 	*kPacketSave = (kPacket *) &kPacketArea[4];
					/* Pointer to kernel packet area */
NetAddress	ServerHostAddress;	/* A one-address cache */
int		ServerLogicalHost = -1;

ProcessId GetFakePid()

  /* Make up a process ID to use for the loader */
  {
    extern Process *Active;
    register char *p;

    EnetHostNumber = ( char ) EIAddress;

    /* Convert to hex for use elsewhere */
    p = HexEnetAddress;
    *p++ = MakeHexDigit(EnetHostNumber>>4);
    *p++ = MakeHexDigit(EnetHostNumber);
    *p = '\0';

    return( Active->pid = 
	(EnetHostNumber<<24 | (K_ticks()&0xff)<<16 | 0xbead)
		& ~LITTLE_ENDIAN_HOST );
  }

    
SystemCode EnetPowerup()

  /*  Powerup and initialize the Ethernet Interface Board.
   */
  {
    register int count;
    
    /* Get hardwired address of this host */
    GetFakePid();

    /* Turn off all bits in address filter */
    EnetStatus = EnetInit + EnetIntDisable + EnetIntLevel1 + EnetNoFilterData;
    EIStatus = EnetStatus; /* Write to interface status register */
    for( count = 0; count < 256; count++ ) EIAddress = count;

    /*  Setup for self only, no broadcast */
    EnetStatus &= ~EnetNoFilterData;
    EIStatus = EnetStatus;
    /* EIAddress = 0;  /* receive broadcast */
    EIAddress = EnetHostNumber;  /* receive self */

    /* Turn off initialization */
    EnetStatus &= ~EnetInit;
    EIStatus = EnetStatus;
    
    EnetFlushReceiver();

    return( OK );
 }




SystemCode AwaitKernelPacket()
   /*  Wait until a valid kernel packet is received.  Return
    *    TIMEOUT if we time out before getting one.
    */
  {
    extern Process *Active;
    register short	words, readwords, doublelwords;
    register short	*p, *save;
    register short	*eidata0 = &EIData0;
    short		status;
    SystemCode		ret;
    register int	loopcount = 0;
    
debug('a');
    while (loopcount++ < MAXLOOPCOUNT)
      {
        /* Check if anything in the receiver FIFO queue */
        if( (EIStatus & EnetRxInt) == 0 ) continue;
debug('b');

	status = *eidata0;
	if( status & EnetQueueEmpty )
				/* This was in reality the lookahead word.
				   The next word is the real status word. */
	  {
debug('l');
	    status = *eidata0;
          }

	/* Find a valid error-free packet */
	while( !(status & EnetQueueEmpty) )
	  {
	    words = (status & EnetCountMask) - 1 /* minus 1 for the CRC */;
	    if( (status & (EnetCollision|EnetOverflow|EnetCRCerror)) == 0 
			&& words <= (ENET3_MAX_PACKET>>1) && words > 8 )
	      {
debug('c');
	        /* A valid packet */

	        /* Get the first eight words of the packet and figure out
	           if it is a non-alias process kernel packet */
	        save = ( short * ) EnetPacket;
	        *save++ = *eidata0; /* SRC and DEST */
	        *save++ = *eidata0; /* Ether type */
		*save++ = *eidata0; /* Kernel packet type */
		*save++ = *eidata0; /* Sequence number */
	        *save++ = *eidata0; /* srcPid */
		*save++ = *eidata0;
		*save++ = *eidata0; /* dstPid */
		*save++ = *eidata0;
	    
	        if( EnetPacket->EtherType != KernelPacketType )
	          {
debug('d');
		    /* First case: it is a non-kernel packet */
		    /* Discard packet, including the checksum,
		     *  and also pick up next status word */
		    words -= 7;
		    do
			status = *eidata0;
		    while (--words != -1);
		    continue;
	          }
	        else
	          {
debug('e');
		    /* Second case : a kernel packet */
		    /*
		     * Note that this only reads the control portion of the 
		     * packet.  The data portion, if there, is read by 
	             * ReadDataPacket().
		     */
		    doublelwords = ((WORDS_PER_PACKET-12)>>2);
		    /* Take advantage of dbra instruction */
		    do
		      {
		        *save++ = *eidata0;*save++ = *eidata0;
		        *save++ = *eidata0;*save++ = *eidata0;
		      }
		    while(--doublelwords != -1);
		    *save++ = *eidata0; *save = *eidata0;

		    ServerHostAddress = EnetPacket->SrcHost;    
		    if (DifferentIKCByteOrder(kPacketSave))
		      {
			SwapIKPacket(kPacketSave);
		      }
		    kPacketSave->packetType &= ~IKC_LITTLE_ENDIAN;
		    ServerLogicalHost = (kPacketSave->srcPid)>>16;
		    return (OK);
	          }
	      }
	    else
	      {
debug('f');
	        /* An invalid packet.  Discard it */

#ifdef DEBUG
if (status & EnetCollision) debug('X');		
if (status & EnetOverflow) debug('Y');
if (status & EnetCRCerror) debug('Z');		
#endif DEBUG
		if (status & EnetOverflow)
		  {
		    EnetFlushReceiver();
		  }
		else
		  {
		    /* move words+1 to flush CRC too */
		    if (words >= 0) do
		        status = *eidata0;
		    while ( --words != -1 );
		  }

		status = *eidata0; /* Read status word for the next packet */
	      }
	  } /* while queue not empty */
      } /* while loopcount-- */
debug('g');
    return (TIMEOUT);
  }




EnetFlushReceiver()

  /* Flush receiver buffer just in case of problems.
   */
  {
    register unsigned count;
    register short status;

    for( count = 0; (count < 0x4000) && (EIStatus & EnetRxInt); ++count )
      status = EIData0;
    /*if( count == 0x4000 ) Kabort( "Ethernet interface failure" );*/
  }

/* Routines specific to the distributed version */

int WriteKernelPacket( type, srcPid, dstPid, forwarder, length, localaddress,
		       remoteaddress, sequenceNo, msg, data )
    short type;
    Process_id srcPid, dstPid, forwarder;
    unsigned length;
    Unspec *localaddress, *remoteaddress;
    unsigned short sequenceNo;
    unsigned short *msg;
    unsigned char *data;
  {
    static ProcessId EnetWriter = 0;
    register short i;
    register short words, lwords;
    register short buffer;
    short transmitterack;
    register short *shortdata = ( short * ) data;
    register short zero = 0;
    register short *eidata0 = &EIData0;
debug('A');
    if( EnetWriter )
      {
debug('B');
        while( (EIStatus & EnetTxInt) == 0 ) ;
debug('C');
        transmitterack = EIAddress;
      }
    EnetWriter = 1;
    if( data == NULL )
	*eidata0 = WORDS_PER_PACKET;
    else
      {
	words = (short) ( ( length >> 1 ) + ( length & 1 ) );
	*eidata0 = (short)(WORDS_PER_PACKET + words);
      }
    if ((dstPid>>16) == ServerLogicalHost)
	*eidata0 = (short)((ServerHostAddress<<8) + EnetHostNumber);
    else
	*eidata0 = (short)((0<<8) + EnetHostNumber); /*broadcast*/
    *eidata0 = KernelPacketType;
    *eidata0 = type & ~IKC_LITTLE_ENDIAN;
    *eidata0 = sequenceNo;
    *eidata0 = (short)(srcPid>>16);
    *eidata0 = (short)(srcPid);
    *eidata0 = (short)(dstPid>>16);
    *eidata0 = (short)(dstPid);
    *eidata0 = (short)(forwarder>>16);
    *eidata0 = (short)(forwarder);
    *eidata0 = zero;			/* user number */
    *eidata0 = zero;
    *eidata0 = (short)(length>>16);
    *eidata0 = (short)(length);
    *eidata0 = (short)((unsigned)localaddress>>16);
    *eidata0 = (short)(localaddress);
    *eidata0 = (short)((unsigned)remoteaddress>>16);
    *eidata0 = (short)(remoteaddress);
    i = 3;
    if( msg == NULL )
        do
	  {
	    *eidata0 = zero; *eidata0 = zero;
	    *eidata0 = zero; *eidata0 = zero;
	  }
	while ( --i != -1 );
    else
	do
	  {
	    *eidata0 = *msg++;*eidata0 = *msg++;
	    *eidata0 = *msg++;*eidata0 = *msg++;
	  }
	while( --i != -1 );
debug('D');
    if( data == NULL )
	return;
    else
      {
debug('E');
	lwords = words>>2;
	if( ((unsigned)data & 1) == 0 )
      	  {
	    if (lwords--) do
	      {
	    	*eidata0 = *shortdata++;*eidata0 = *shortdata++;
	    	*eidata0 = *shortdata++;*eidata0 = *shortdata++;
	      }
	    while (--lwords != -1);
	    if( words & 2 ) {*eidata0 = *shortdata++;*eidata0 = *shortdata++;}
	    if( words & 1 ) *eidata0 = *shortdata++;
      	  }
        else
          {
	    if (lwords--) do
	      {
	    	buffer = *data++;
	    	*eidata0 = buffer<<8 | *data++; 
	    	buffer = *data++;
	    	*eidata0 = buffer<<8 | *data++; 
	    	buffer = *data++;
	    	*eidata0 = buffer<<8 | *data++; 
	    	buffer = *data++;
	    	*eidata0 = buffer<<8 | *data++; 
	      }
	    while(--lwords != -1);
	    if( words & 2 )
	      {
	    	buffer = *data++;
	    	*eidata0 = buffer<<8 | *data++;
	    	buffer = *data++;
	    	*eidata0 = buffer<<8 | *data++;
	      }
	    if( words & 1 )
	      {
	    	buffer = *data++;
	    	*eidata0 = buffer<<8 | *data++;
	      }
          }
    	return;
      }
  }

int ReadDataPacket ( bytes, dst )
    unsigned bytes;
    register unsigned char *dst;
  {
    register int words, lwords;
    register short *shortdst = (short *) dst;
    register short buffer;
    register short *eidata0 = &EIData0;

debug('0');
    words = bytes >> 1;
    lwords = words >> 2;
    ++lwords;
    if( ((unsigned)dst & 1) == 0 )
      {
	while (--lwords) 
	  {
	    *shortdst++ = *eidata0;*shortdst++ = *eidata0;
	    *shortdst++ = *eidata0;*shortdst++ = *eidata0;
	  }
 	if( words & 2 ) {*shortdst++ = *eidata0;*shortdst++ = *eidata0;}
	if( words & 1 ) *shortdst++ = *eidata0;
      } 
    else
      {
	while (--lwords)
	  {
	    buffer = *eidata0;
	    *dst++ = (unsigned char)(buffer>>8);
	    *dst++ = (unsigned char)(buffer);
	    buffer = *eidata0;
	    *dst++ = (unsigned char)(buffer>>8);
	    *dst++ = (unsigned char)(buffer);
	    buffer = *eidata0;
	    *dst++ = (unsigned char)(buffer>>8);
	    *dst++ = (unsigned char)(buffer);
	    buffer = *eidata0;
	    *dst++ = (unsigned char)(buffer>>8);
	    *dst++ = (unsigned char)(buffer);
	  }
	if( words & 2 )
	  {
	    buffer = *eidata0;
	    *dst++ = (unsigned char)(buffer>>8);
	    *dst++ = (unsigned char)(buffer);
	    buffer = *eidata0;
	    *dst++ = (unsigned char)(buffer>>8);
	    *dst++ = (unsigned char)(buffer);
	  }
	if( words & 1 )
	  {
	    buffer = *eidata0;
	    *dst++ = (unsigned char)(buffer>>8);
	    *dst++ = (unsigned char)(buffer);
	  }
      }
    if( bytes & 1 )
      {
	if( ((unsigned)dst & 1) != 0 )
	    *dst = (unsigned char) (*eidata0>>8);
	else
	  {
	    dst = (unsigned char *) shortdst;
	    *dst = (unsigned char) (*eidata0>>8);
	  }
      }

    buffer = *eidata0;			/* discard checksum */
  }

int DiscardDataPacket ( bytes ) unsigned bytes;

  {
    register int words, lwords;
    register short status;
    register short *eidata0 = &EIData0;

debug('1');
    words = (bytes>>1) + (bytes&1);
    lwords = words>>2;
    ++lwords;
    while (--lwords) 
      {
	status = *eidata0;status = *eidata0;
	status = *eidata0;status = *eidata0;
      }
    if( words & 2 ) {status = *eidata0;status = *eidata0;}
    if( words & 1 ) status = *eidata0;

    status = *eidata0;
  }

