/*
 * V Kernel - Copyright (c) 1982 by David Cheriton
 *
 * Ethernet header: manifests, types, structs local to Ethernet code.
 */

#ifndef _ETHERNET
#define _ETHERNET

#include "Vexceptions.h"
#define MBMEM_OFFSET 0x100000

#ifdef ENET10MEG
/*    Definitions for the 3com Multibus ethernet interface    */

#define UNITOFFSET	0x2000	/* address space range of one unit */

/*  ME controller addresses */
#define  P_MEBASE 0xE0000	  /* ME memory base address */
#define  MEBASE  (MBMEM_OFFSET+P_MEBASE)
#define  MECSR    MEBASE	 /* control and status register */
#define  MEBACK  (MEBASE+2)      /* retransmission backoff counter */
#define  MEADROM (MEBASE+0x400)  /* station address (in ROM) */
#define  MEADRAM (MEBASE+0x600)  /* station address (in RAM) */

/* Transmission parameters */
#define  METXHDR (MEBASE+0x800)  /* transmit buffer header */
#define  SENDBUF (MEBASE+0x802)  /* Transmit buffer */
#define  SENDEND (MEBASE+0x1000) /* End of send buffer */
#define  SENDHEAD	14	/* dest(6) + source(6) + type(2) */
#define  RECHEAD	14	/* dest(6) + source(6) + type(2) */
#define	 RECTAIL	4	/* CRC(4) */
#define  MINPKT		46	/* Smallest legitimate ether (data) packet */
#define  MAXPKT		1500	/* Biggest legitimate ether (data) packet */

/* Receive Parameters */
#define  MEAHDR  (MEBASE+0x1000) /* receive buffer A header */
#define  MEBHDR  (MEBASE+0x1800) /* receive buffer B header */

/*  Bits in status and control register MECSR  */
#define  BBSW	0x8000	/* write 1 to release, read 0 when packet received */
#define  ABSW	0x4000	/* write 1 to release, read 0 when packet received */
#define  TBSW	0x2000	/* write 1 to transmit, read 0 when complete */
#define  JAM	0x1000	/* read 1 if collision, write 1 to retransmit */
#define  AMSW   0x0800  /* write 1 to give station address to controller */
#define  RBBA   0x0400  /* read 1 if B older than A (only if ABSW=BBSW=0) */
#define  RESET  0x0100  /* write 1 to reset controller */
#define  BINTEN 0x0080  /* write 1 to interrupt when packet received in A */
#define  AINTEN 0x0040  /* write 1 to interrupt when packet received in B */
#define  TINTEN 0x0020  /* write 1 to interrupt when transmission complete */
#define  JINTEN 0x0010  /* write 1 to interrupt when collision occurs */
#define  RXMODE	0x0005
			/* receive criteria:  
			      0  all packets	(promiscuous mode)
			      1  all - errors
			      2  all - fcs - frame
			      3  this host + multicast
			      4  this host + multicast - errors
			      5  this host + multicast - fcs - frame
			      6  this host + broadcast
			      7  this host + broadcast - errors
			      8  this host + broadcast - fcs - frame 
			   Note that multicast => broadcast.
			  */
/*  Bits in receive packet header MEAHDR or MEDHDR  */
#define  FCSerr		0x8000	/* data CRC error */
#define  BROADcast	0x4000  /* broadcast packet */
#define  RANGerr	0x2000  /* range error */
#define  ADRmatch	0x1000  /* address match */
#define  FRAMerr	0x0800  /* framing error */
#define  FREEmask	0x07FF  /* free pointer mask */
#define  STATmask	0xF800  /* status mask */
#define  NORMALhdr	0x4000  /* normal receive status */

#define  ENET_INT_LEVEL	INT3	/* Multibus interrupt level for the board */

#define ENET_READER_TIMEOUT	5	/* 50 ms timeout on read */
#endif

#endif
