/*
 * chaos.h - Definitions for ChaosNet packets on the Ethernet
 *
 * Contributed by Bill Yeager, SUMEX, March 1986
 *
 * Copyright (c) Stanford University, 1986
 */

#define CHAOS 0x804			/* link level type - 10mb 4004(8) */
#define CHAOS3MB 0x800			/*   4000(8) - 3mb */

#define LOADSHORT(w) (((unsigned short)w >> 8) | ((unsigned short)w << 8))

/*
 *	We receive this packet in REVERSE byte
 *	order. This screws up shorts.
 */
typedef struct chaoslev1 {
    unsigned char reserved;		/* spare */
    unsigned char opcode;		/* the opcode */
    unsigned short hops4Length12;	/* 4 bits hops - 12 bits length */
    unsigned char dhost,dnet;		/* destination network address */
    unsigned short dindex;		/* destination index */
    unsigned char shost,snet;		/* source network address */
    unsigned short sindex;		/* source index */
    unsigned short paknum;		/* packet number */
    unsigned short ack;			/* acknowledgement */
    unsigned char data[2];		/* data starts here */
  } CHAOSLEV1;
#define CHAOSLEV1LEN (sizeof(CHAOSLEV1)-2)

/*
 *	Chaos net opcodes
 */
#define CHAOSRFC  01
#define CHAOSANS  05
#define CHAOSRUT 010
#define CHAOSBRD 016

typedef struct rutentry {
  	unsigned short subnet,
	        cost;
  } RUTENTRY;
#define RUTENTRYLEN (sizeof(RUTENTRY))
