
#include <Venviron.h>
#include <Vio.h>

extern int FirstBuffer, LastBuffer, MaxBuffers, BufferSize;
extern int StartTime, HitFlag, TickFlag, EtherReady();
extern short myAddress[];
extern char userName[], cwd[], *Buffer();

WriteFile()
  {
    /*
     * write the accumulated buffers to the indicated file name
     */

    char name[128], fullname[128];
    int i;
    FILE *out;

    fflush(stdin);
    name[0] = fullname[0] = 0;
    if (FirstBuffer==LastBuffer)
      {
        printf("\nBuffer is empty -- you must record something first\n");
	return;
      }
    Echo(); Cooked();
    printf("\nWrite to file (user: %s dir: %s): ",userName,cwd[0]?cwd:"<none>");
    gets(name);
    NoEcho(); Raw();
    if (!*name) return;
    
    if (name[0] != '[')
      {
	strcpy(fullname, cwd);
	strcat(fullname, "/");
      }
    strcat(fullname, name);

    EnetPowerup();		/* initialize V simulator */

    out = fopen( fullname, "w" );
    if (out == NULL)
      {
        printf( "Unable to open %s for output.\n", fullname );
        return;
      }
    i = FirstBuffer;
    while( i != LastBuffer )
      {
        PrintBuffer( Buffer(i), out );
	printf(".");
	i = (i + 1) % MaxBuffers;
      }
    fclose(out);
    printf("\n%d packets written to %s.\n",
		(LastBuffer >= FirstBuffer) ? LastBuffer - FirstBuffer
			: MaxBuffers - ( FirstBuffer - LastBuffer ), fullname );
  }

netwatch( printflag )
register int printflag;
  {
    int buf;

    EtherInit( myAddress );
    EnetSetFilter();

    printf("\nListening...\n");
    StartTime = K_ticks();
    HitFlag = 0;
    buf = FirstBuffer = LastBuffer;
    while (!KeyHit())
	if( ReadPacket() )
	    if ( printflag )
	      {
		PrintBuffer( Buffer(buf), stdout );
		if (++buf == MaxBuffers) buf = 0;
	      }
	    else
		if (TickFlag && !EtherReady()) putc('!', stdout);
    EnetNormalFilter();
    HitFlag = 0;
    printf("\n%d packets are recorded in the buffer.\n",
	(LastBuffer >= FirstBuffer) ? LastBuffer - FirstBuffer
		: MaxBuffers - ( FirstBuffer - LastBuffer ) );
  }

showbuffer( skipflag )
    int skipflag;
  {
    int buf, npackets, nskip;

    if (FirstBuffer==LastBuffer)
      {
	printf("\nBuffer is empty -- you must record something first\n");
	return;
      }

    if( skipflag )
      {
	printf("\nNumber of packets to skip: ");
	Echo(); Cooked();
	scanf( "%d", &nskip );
	NoEcho(); Raw();
      }
    else nskip = 0;

    npackets = (LastBuffer >= FirstBuffer) ? LastBuffer - FirstBuffer
		: MaxBuffers - ( FirstBuffer - LastBuffer );
    if( nskip >= npackets )
      {
	printf( "\nThere %s only %d packet%s in the buffer\n",
			npackets == 1 ? "is" : "are",
			npackets,
			npackets == 1 ? "" : "s" );
	return;
      }

    printf("\nBuffered packets...\n");
    buf = FirstBuffer;
    if( nskip > 0 ) while( nskip-- ) buf = (buf + 1) % MaxBuffers;

    HitFlag = 0;
    while( !KeyHit() )
      {
	PrintBuffer( Buffer(buf), stdout );
	buf = (buf + 1) % MaxBuffers;
	if( buf == LastBuffer )
	  {
	    printf( "      ---- End of buffer -- hit any key to return to main menu ----  " );
	    while( !KeyHit() )
		;
	    break;
	  }
      }
    HitFlag = 0;
  }
