/*
 *
 * Excelan 10 Mbit Ethernet driver
 */

typedef struct {
   short addrlow, addrmid, addrhigh;
   } NetAddress;
# define ENET_MAX_PACKET 1500
# define NULL	0

# include "excelan.h"


NetAddress	EnetHostNumber = 0;	/* Physical ethernet address. */
int		Poweredup = 0;		/* did power-up sequence */
struct MsgBuf *GetMsgBuf();


/*
 * Significant addresses referring to Multibus memory.
 */

unsigned	MultibusMemAddr;	/* Base address of my area of */
					/* Multibus memory. */
char		*VMultibusMemAddr;	/* Virtual address of above. */

char		*ReadDataBuf;		/* Buffer for incoming packets. */
char		*WriteDataBuf;		/* Buffer for outgoing packets. */
char		*StatsBuffer;		/* Buffer for statistics replies. */

struct MsgQs	*MsgQPtr;		/* Start of request/reply queues. */
unsigned	MsgQVirAddr;		/* Virtual address of same. */
unsigned	MsgQPhysAddr;		/* Physical address of same. */
unsigned	MsgQVirSegAddr;		/* Start of segment of same--Exos's */
					/*  16 bit offsets are calculated */
					/*  from here.  Luckily, the */
					/*  AllocateMultibusMemory routine */
					/*  returns areas which begin or end */
					/*  on a segment boundary. */

char *EtherKind()
	/*
	 * return a string identifying what kind of interface we are
	 */
  { return("Excelan"); }

char *PrintEtherStatus(status)
    short status;
  {
  	/*
	 * Return a Human-readable string for the Ethernet status
	 */
    char buf[80];
    
    if (status==0)
      return("OK");

    strcpy(buf,"");
    if (status & AlignmentError)
        strcpy(buf,"Alignment Error ");
    if (status & CRCError)
        strcat(buf,"CRC Error ");
    return(buf);
  }



EtherBadStatus(status)
    short status;
  {
  	/*
	 * returns TRUE if the status indicates any kind of errors
	 */
    return( status &(AlignmentError+CRCError));
  }


EtherInit(stationAdd) 
    short *stationAdd;
 {
    /*
     *  Powerup and initialize the Ethernet Interface Board.
     */
    int dummy, i, bytes;
    long addr;
    struct ReadMsg *readmsg;
    struct SystemBuffers *systembuf;
    struct MsgBuf *bufptr, *nextbufptr;
    struct Init *configmsg;
    struct testp *testpat;

    /* Reset board. */

    dummy = PORTA;			/* Reading PORTA does reset. */
    i = 0;
    while( ( PORTB & X_ERROR ) == 0 )	/* Test status--wait for response. */
      if( i++ > 400000 )
	{
	  printf( "Excelan Driver:  Interface didn't reset.\n" );
	  return;
	}

    /* Set up Multibus Memory--the shared memory between board and processor. */

    bytes = sizeof( struct SystemBuffers ) + sizeof( struct MsgQs );
    AllocateMultibusMemory( bytes, &MultibusMemAddr, &VMultibusMemAddr );
    systembuf = (struct SystemBuffers *) VMultibusMemAddr;
    ReadDataBuf = systembuf->readbuffer;
    WriteDataBuf = systembuf->writebuffer;
    StatsBuffer = systembuf->statsbuffer;
    MsgQVirAddr = (long)( VMultibusMemAddr + sizeof( struct SystemBuffers ) );
    MsgQPhysAddr = VirToPhys( MsgQVirAddr );
    MsgQVirSegAddr = MsgQVirAddr & ( ~0xffff );
    clear( MsgQVirAddr, sizeof( struct MsgQs ) );

    /* Initialize message queues. */

    MsgQPtr = (struct MsgQs *) MsgQVirAddr;
    MsgQPtr->xreqhdr = HostToExAddr( MsgQPtr->requestbufs );
    MsgQPtr->xreptail = HostToExAddr( MsgQPtr->replybufs );
    MsgQPtr->hreqtail = MsgQPtr->requestbufs;	/* Not used--see GetMsgBuf. */
    MsgQPtr->hrephdr = MsgQPtr->replybufs;

    /* Initialize request buffers--Host to Exos buffers. */

    bufptr = &( MsgQPtr->requestbufs[ NREQBUFS - 1 ] );
    for( i = 0; i < NREQBUFS; i++ )
      {
	nextbufptr = &( MsgQPtr->requestbufs[i] );
	bufptr->next = nextbufptr;
	bufptr->msg.link = HostToExAddr( nextbufptr );
	bufptr->msg.length = MSGLEN;
	bufptr->msg.status = HOST_OWNER | EXOS_DONE;
	bufptr = nextbufptr;
      }

    /* Initialize reply buffers--Exos to Host buffers. */

    bufptr = &( MsgQPtr->replybufs[ NREPBUFS - 1 ] );
    for( i = 0; i < NREPBUFS; i++ )
      {
	nextbufptr = &( MsgQPtr->replybufs[i] );
	bufptr->next = nextbufptr;
	bufptr->msg.link = HostToExAddr( nextbufptr );
	bufptr->msg.length = MSGLEN;
	bufptr->msg.status = EXOS_OWNER | HOST_DONE;
	bufptr = nextbufptr;
      }

    /* Construct configuration message. */

    configmsg = (struct Init *) ReadDataBuf;	/* Beginning of buffer space. */
    clear( configmsg, sizeof *configmsg );	/* Defaults all values to 0. */

    configmsg->res0 = 1;			/* Excelan doc: pgs. 24-5. */
    configmsg->code = 0xff;
    configmsg->mode = 0;			/* Link level cntrlr mode. */
    configmsg->format[0] = 1;			/* Look at test pattern. */
    configmsg->format[1] = 1;
    testpat = (struct testp *) configmsg->mmap;
    testpat->b0 = 1;
    testpat->b1 = 3;
    testpat->b2 = 7;
    testpat->b3 = 0xf;
    testpat->w0 = 0x103;
    testpat->w1 = 0x70f;
    testpat->l0 = 0x103070f;
    configmsg->amode = 3;			/* Absolute address mode. */
    configmsg->mvblk = -1L;			/* 0xffffffff  */
    configmsg->nproc = 0xff;
    configmsg->nmbox = 0xff;
    configmsg->naddr = 0xff;
    configmsg->nhost = 1;
    configmsg->hxitype = 3;			/* no Interrupts. */
    configmsg->xhitype = 3;
    configmsg->hxseg = VirToPhys( MsgQVirSegAddr );
				/* Request Q offsets calculated from here. */
    configmsg->xhseg = VirToPhys( MsgQVirSegAddr );
				/* Reply Q offsets calculated from here. */
    configmsg->hxhead = ( (int) &MsgQPtr->xreqhdr - MsgQVirSegAddr );
    configmsg->xhhead = ( (int) &MsgQPtr->xreptail - MsgQVirSegAddr );

    /* According to the previous version of this code, Exos version 1.4
     * requires a disallowed address be sent first for synchronization
     * (0xffff0000).  Valid addresses must have high byte == 0, because
     * 24 bits is the maximum physical address.
     */

    addr = 0x0000ffff;
    for( i = 0; i < 4; i++ )
      {
	while( PORTB & X_NOT_READY );		/* Wait for device ready. */
	PORTB = addr & 0xff;
	addr >>= 8;
      }

    /* Now send physical address of configmsg. */

    addr = VirToPhys( configmsg );
    for( i = 0; i < 4; i++ )
      {
	while( PORTB & X_NOT_READY );		/* Wait for device ready. */
	PORTB = addr & 0xff;
	addr >>= 8;
      }

    /* Wait for Exos to change code. */

    i = 0;
    while( configmsg->code == 0xff )
      if( i++ > 1000000 )
	{
	  printf( "Excelan driver: Timeout waiting for board to configure.\n" );
          break;
	}
    if( configmsg->code != 0 ) 
	printf( "Excelan driver: Error on initialization.\n" );

    GetSlot( PHYS_ADDRS_SLOT, stationAdd );
    SetMode( Promiscuous );

    /* Construct and send a read request--allowing reception of any packets
     * which might come in.
     */

    readmsg = (struct ReadMsg *) GetMsgBuf();
    if( !readmsg ) printf( "Excelan driver: No read msg buffer.\n" );

    readmsg->request = NET_READ;
    readmsg->nblocks = 1;
    readmsg->block[0].len = ENET_MAX_PACKET;
    readmsg->block[0].addr = VirToPhys( ReadDataBuf );
    readmsg->id = NET_READ;			/* Not used currently. */
    readmsg->status = EXOS_OWNER | HOST_DONE;
    PORTB = 0;					/* Interrupt board to notify
						   it of new read request. */
    Poweredup = 1;
  }

/*
 * Allocate some Multibus memory.  Horrible assumptions: we know that the 
 *   Sun 2 monitor maps virtual addresses 140000-1FFFFF to Multibus memory
 *   addresses 40000-FFFFF (i.e. all but the first 256K), so we just point
 *   things to the right (?) places and don't check or alter the memory map.
 *   We further assume that there's RAM starting at 40000 (256K) on the
 *   Multibus, and as much of it as we need.
 */
#define MB_MEMORY_BASE	0x40000

#define V_MBUS_MAP	0x140000
#define MB_MBUS_MAP	0x40000

AllocateMultibusMemory( bytes, mp, vmp )
    int bytes, *mp, *vmp;
  {
    *mp  = MB_MEMORY_BASE;
    *vmp = (MB_MEMORY_BASE - MB_MBUS_MAP) + V_MBUS_MAP;
  }


EtherReady()
  {
  	/*
	 * returns True if there is a packet waiting in either  hardware buffer
	 */
    short status;
    
    return( ( (MsgQPtr->hrephdr)->msg.status ) == HOST_OWNER|EXOS_DONE ); 
  }


EnetSetFilter()
  {
  	/*
	 * set our temporary filter, so we can watch.
	 */
  }


EnetNormalFilter()
  {
  	/*
	 * restore the "normal" filter, so we can write to a file.
	 */
  }


 EnetQuery( )
  {
    /* Send a NET_STATS request to the board, and return its answers to the
     * querier.  Note that we are normally configuring the interface to
     * ignore packets with CRC or alignment errors, so these figures may
     * be 0 all the time.  Also note that the board does not count the
     * number of collisions, so an estimate of these is maintained in
     * EnetInterrupt.
     */

    struct StatsMsg *statsmsg;
    struct StatsArray *statsarray;

    statsmsg = (struct StatsMsg *) GetMsgBuf();
    if( !statsmsg )
      printf( "Excelan Driver: EnetQuery couldn't get a msg buffer.\n" );

    statsmsg->request = NET_STATS;
    statsmsg->reqmask = READREQ;
    statsmsg->res1 = 0;
    statsmsg->nobj = NUM_STATS_OBJS;
    statsmsg->index = 0;		/* Start of stats array. */
    statsmsg->bufaddr = (long) StatsBuffer;
    statsmsg->id = NET_STATS;
    statsmsg->status = EXOS_OWNER | HOST_DONE;
    PORTB = 0;

    WaitForCompletion( NET_STATS );	/* Stats calls don't take long-- */
					/* we can wait? */

    statsarray = (struct StatsArray *) StatsBuffer;

  } 


short *EtherPeek()
    /*
     * Returns a pointer to the packet buffer in multibus memory, so
     * caller can avoid copying out the packet if it is unwanted.
     */
  {
    return (short *) ReadDataBuf;
  }


EtherDrop()
   /*
    * Drop an unwanted packet.  Presumably we know it was unwanted because
    * we peeked at it with EtherPeek.
    */
  {
    register struct ReadMsg *replybuf;
    register count;
    register short *src;
    
    PORTA = 1;
 
    replybuf = (struct ReadMsg *)MsgQPtr->hrephdr;

    /* Return this buffer to Exos's control and look at the next to */
    /* see if there was more than one reason for this interrupt. */
    FinishPacket();

    replybuf->length = MSGLEN;
    replybuf->status = EXOS_OWNER|HOST_DONE;
    replybuf =  (struct ReadMsg *) ((struct MsgBuf *)replybuf)->next;

    /* Look at this reply buffer next time we get called */
    MsgQPtr->hrephdr = (struct MsgBuf *)replybuf;
    PORTB = 0;					/* Interrupt board to notify
						   it of new read request. */
  }


EtherRead(buf)
      register short *buf;
   /*
    * Handle a read from the ethernet interface. 
    * We copy the packet from Multibus memory into the indicated buffer,
    * First we copy in the status, and then the byte count.
    */
  {
    register struct ReadMsg *replybuf;
    register short count;
    register short *src;
    
    PORTA = 1;
 
    replybuf = (struct ReadMsg *)MsgQPtr->hrephdr;

	/* A reply is ready! */

    if( replybuf->request == NET_READ )
	  {
	    /* It's a read reply! */
	
	    *buf++ = replybuf->reply;
	    *buf++ = replybuf->block[0].len - 6;
	    src =  (short *) ReadDataBuf;

	    Copy(buf, src, replybuf->block[0].len);
	  }

	/* else  NET Command.  We busy-waited for this to be done so */
	/*   nothing has to be done here.  See SetMode for more info. */

	/* Return this buffer to Exos's control and look at the next to */
	/* see if there was more than one reason for this interrupt. */
	FinishPacket();

	replybuf->length = MSGLEN;
	replybuf->status = EXOS_OWNER|HOST_DONE;
	replybuf =  (struct ReadMsg *) ((struct MsgBuf *)replybuf)->next;

    /* Look at this reply buffer next time we get called */
    MsgQPtr->hrephdr = (struct MsgBuf *)replybuf;
    PORTB = 0;					/* Interrupt board to notify
						   it of new read request. */
  }



FinishPacket()
  {
    /* Signal the read buffer as empty, and request any packet coming in. */
    struct ReadMsg *readmsg;

    readmsg = (struct ReadMsg *) GetMsgBuf();
    if( !readmsg )
      printf( "Excelan Driver: FinishPacket couldn't get a msg buffer.\n" );

    readmsg->request = NET_READ;
    readmsg->nblocks = 1;
    readmsg->block[0].len = ENET_MAX_PACKET;
    readmsg->block[0].addr = VirToPhys( ReadDataBuf );
    readmsg->id = NET_READ;
    readmsg->status = EXOS_OWNER | HOST_DONE;
    PORTB = 0;
  }

struct MsgBuf *IGetMsgBuf()
  {
    /* Find an empty request buffer.  Note that we start looking for an
     * empty one where Exos is about to look for a request--not at the
     * end of the request queue, which would be MsgQPtr->hreqtail.  It
     * doesn't matter in our case, since we never send more than one
     * message at a time, but when I'm sure I know what's going on, I'm
     * going to go back and fix this.  Besides, it's the only use of
     * the macro ExToHostAddr.  --EJB
     */
    register int i;
    register struct MsgBuf *bufptr;

    bufptr = (struct MsgBuf *) ExToHostAddr( MsgQPtr->xreqhdr );
    i = 0;
    while( i++ < NREQBUFS  &&  bufptr->msg.status != (HOST_OWNER|EXOS_DONE) )
      bufptr = bufptr->next;
    if( bufptr->msg.status == (HOST_OWNER|EXOS_DONE) )
      {
	bufptr->msg.status = HOST_OWNER|HOST_DONE;
	bufptr->msg.res = 0;
	clear( &bufptr->msg.pad, MSGLEN );
	return( bufptr );
      }
    else
	return( 0 );
  }


struct MsgBuf *GetMsgBuf()
  {
    /*
     * Try 50 times to get a message buffer.
     */
    register timer;
    register struct MsgBuf *bufptr;

    timer = 50;
    while( timer-- != 0 )
      if( (bufptr = IGetMsgBuf()) != NULL ) return( bufptr );
    return( 0 );
  }



/*
 * When we use this driver in netwatch, with V rather than leaf I/O, we also
 *   load the ethernet driver from the standalone library (two drivers - ugh).
 *   Since that has its very own SetMode routine, we make this one static -
 *   I'm not willing to gamble on trying to have just one SetMode routine.
 */
static SetMode( newmode )
	unsigned newmode;
  {
    /*
     * Set the mode of the interface.
     */
    register struct ModeMsg *modemsg;
    register timer;

    modemsg = (struct ModeMsg *) GetMsgBuf();
    if( !modemsg ) printf( "Excelan Driver: Mode set couldn't get msg buffer.\n");

    modemsg->request = NET_MODE;
    modemsg->reqmask = WRITEREQ;
    modemsg->mode = newmode;
    modemsg->errmask = AlignmentError+CRCError;
    modemsg->id = NET_MODE;	/* No more than one mode cmd at a time. */
    modemsg->status = EXOS_OWNER|HOST_DONE;
    PORTB = 0;			/* Interrupt interface. */

    /* Wait for a response from the interface.  NOTE: We are being extremely
     * cautious and not reenabling interrupts at this point (they're turned
     * off in the kernel).  Therefore, the only way for Exos to tell us it
     * is done with this command is to add a new reply to the tail of the
     * reply queue.  This scheme will work ONLY because there are no other
     * requests outstanding at the time this routine is called.
     */

    timer = X_TIMEOUT;
    while( timer-- != 0 )
      if( (MsgQPtr->hrephdr)->msg.status == HOST_OWNER|EXOS_DONE )
	{
	  /* Since I am effectively processing an interrupt before */
	  /* it arrives, I must do all the things EnetInterrupt would. */
	  /* EnetInterrupt will then ignore the interrupt when it is sent, */
	  /* because it won't see any buffers which belong to the Host. */
	  (MsgQPtr->hrephdr)->msg.length = MSGLEN;
	  (MsgQPtr->hrephdr)->msg.status = EXOS_OWNER | HOST_DONE;
	  (MsgQPtr->hrephdr) = (MsgQPtr->hrephdr)->next;
	  return;
	}
    printf( "Excelan Driver: SetMode timed out.\n" );
  }



GetSlot( slotno, dst )
	int slotno;
	char *dst;
  {
    /*
     * Get the address stored in the address slot slotno.  When slotno =
     * PHYS_ADDRS_SLOT, returns the physical address of the board.
     */
    register struct AddrsMsg *addrmsg;
    register int timer;
    int i;
    char *src;
    struct AddrsMsg *msgptr;

    addrmsg = (struct AddrsMsg *) GetMsgBuf();
    if( !addrmsg ) printf( "Excelan Driver: GetSlot can't get a msg buffer.\n" );

    addrmsg->request = NET_ADDRS;
    addrmsg->reqmask = READREQ;
    addrmsg->slot = slotno;
    addrmsg->id = NET_ADDRS;	/* No more than one outstanding at a time. */
    addrmsg->status = EXOS_OWNER|HOST_DONE;
    PORTB = 0;			/* Interrupt the board. */

    /* For the reasoning behind this section, see SetMode. */

    timer = X_TIMEOUT;
    while( timer-- != 0 )
      if( (MsgQPtr->hrephdr)->msg.status == HOST_OWNER|EXOS_DONE )
	{
	  msgptr = (struct AddrsMsg *) &( (MsgQPtr->hrephdr)->msg );
	  src = (char *) &( msgptr->addr );
	  for( i = 0; i < sizeof( NetAddress ); i++ )
	    *dst++ = *src++;

	  /* Since I am effectively processing an interrupt before */
	  /* it arrives, I must do all the things EnetInterrupt would. */
	  /* EnetInterrupt will then ignore the interrupt when it is sent, */
	  /* because it won't see any buffers which belong to the Host. */
	  (MsgQPtr->hrephdr)->msg.length = MSGLEN;
	  (MsgQPtr->hrephdr)->msg.status = EXOS_OWNER | HOST_DONE;
	  (MsgQPtr->hrephdr) = (MsgQPtr->hrephdr)->next;
	  return;
	}
    printf( "Excelan Driver: GetSlot timed out.\n" );
  }



WaitForCompletion( id )
	long id;
  {
    /* Wait for the completion of the command whose id is id. */
    /* The strategy is to examine all the reply buffers in the reply */
    /* message queue until one appears with the correct id, or timeout */
    /* occurs. */

    int timer, i;
    int found = FALSE;
    struct MsgBuf *bufptr;

    timer = X_TIMEOUT;
    bufptr = MsgQPtr->hrephdr;
    while( timer-- > 0  &&  !found )
      {
	for( i = 0; i < NREPBUFS; i++ )
	  if( bufptr->msg.status == (HOST_OWNER | EXOS_DONE) &&
	      bufptr->msg.id == id )
	    found = TRUE;
	bufptr = bufptr->next;
      }
    if( !found ) printf( "Excelan Driver: WaitForCompletion timed out.\n" );
  }


