
/*#include "../../include/process.h"*/
#include <Vikc.h>
#include <Vethernet.h>
#include "enet75.h"
#include "sun3mem.h"

#define RECEIVE_BUFFERS 80

#ifdef DEBUG
#define debug(c) K_putchar(c)
#else
#define debug(c)
#endif

#define CopyMsg(to, from) Copy(to, from, sizeof(MsgStruct))
#define Offset(addr) ((unsigned short)(((long)(addr))-((long)&(lcbsp->scb))))
/*#define Address(offset) ((char *) (((long)offset) + (long)&(lcbsp->scb)))*/

extern unsigned short swap1();
extern swabSmall();
int ReceiverNotReady;

static struct SystemConfigurationPointer *scp;
/* Control Block Segment */
typedef struct
  {
    struct ISystemConfigurationPointer iscp;
    struct SystemControlBlock scb;
    struct IAsetupblock IAsetupBlock;
    struct TransmitBufferDescriptor tbd;
    struct ReceiveFrameDescriptor rfa[RECEIVE_BUFFERS];
    struct ReceiveBufferDescriptor rbd[RECEIVE_BUFFERS];
    struct Configureblock cb;
  } LocalControlBlockSegment;

#define lcbsp ((LocalControlBlockSegment *) ENET_DATA_SEG)

char *local_rbuf;

Enet10Address EnetHostNumber;
int LastStatus;
static struct ReceiveFrameDescriptor *IncomingFrame, *NextFrame, *LastFrame;

extern int IntOccured;

asm("    .text");
asm("    .globl nAsm_EnetInterrupt");
asm("    nAsm_EnetInterrupt:");
asm("    orw	#/0700,sr");
asm("	 moveml	#/c0c0,sp@-");		/* Save d0,d1,a0,a1 */
asm("    jbsr	nEnetInterrupt");
asm("    andw	#/F2FF,sr");
asm("	 orw	#/0200,sr");
asm("	 moveml	sp@+,#/0303");		/* Restore registers */
asm("	 rte");				/* Return */

nEnetInterrupt()
  {
    register struct SystemControlBlock *c = &lcbsp ->scb;
    register int LastStatus;
    register short *ptr, i;
    register int buf;
    
    LastStatus = swap1(c->status);
    if (LastStatus & RNR) ReceiverNotReady = 1;
    if (LastStatus & FR)
      {
	if ((ReceiverNotReady == 0) && (++IncomingFrame == LastFrame))
	    IncomingFrame = lcbsp->rfa;
      }
    c->command = c->status & sACK_MASK; /* Acknowledge */
    c->CBLoffset = 0xFFFF; /* palindrome - no need to swap this */
    Attention();
    IntOccured = 2;
  }

InitEnetRead()
  {
    register int i;
    register LocalControlBlockSegment *c = lcbsp;
    register struct ReceiveFrameDescriptor *f = c->rfa;
    register struct ReceiveBufferDescriptor *r = c->rbd;
    register char *bp;

    K_putchar('#');
    
    local_rbuf = ((char *) lcbsp) + sizeof(LocalControlBlockSegment);

    IncomingFrame = NextFrame = &lcbsp->rfa[0];
    c->scb.command = RUC_START;
    c->scb.RFAoffset = Offset(f);
    c->scb.CBLoffset = 0xffff;
    swabSmall(&(c->scb), sizeof(struct SystemControlBlock));

    for(i = 0; i < RECEIVE_BUFFERS; i++, f++, r++)
      {
	if (i == 0)
	  {
	    f->buffer = Offset(r);
	    (f+(RECEIVE_BUFFERS-1))->link = Offset(f); /* circular lists */
	    (r+(RECEIVE_BUFFERS-1))->next = Offset(r);
	  }
	else
	    f->buffer = 0xffff;
	f->command = 0;
	r->count = 0;
	r->size = ENET_MAX_DATA + sizeof( Enet10Header );
	bp = local_rbuf + ( i * ENET_MAX_DATA );
	r->bufferlow = LOW( bp );
	r->bufferhigh = HIGH( bp );

	if (i == RECEIVE_BUFFERS-1)
	  {
	    f->command = 0x8000; /* end of list */
	    r->size |= 0x8000;
	  }
        else
	  {
	    f->link = Offset(f+1);
	    r->next = Offset(r+1);
	  }
	swabSmall(f, sizeof(struct ReceiveFrameDescriptor));
	swabSmall(r, sizeof(struct ReceiveBufferDescriptor));
      }
    Attention();
    ReceiverNotReady = 0;
  }

char MemoryInitialized = 0;

InitMemory()
  {
/* Allocate 32k of ethernet space */    
    SetPageMap(ENET_DATA_SEG + (4 * PAGE_SIZE), 0xC30001F7);
    SetPageMap(ENET_DATA_SEG + (5 * PAGE_SIZE), 0xC30001F6);
    SetPageMap(ENET_DATA_SEG + (6 * PAGE_SIZE), 0xC30001F5);
    SetPageMap(ENET_DATA_SEG + (7 * PAGE_SIZE), 0xC30001F4);
    SetPageMap(ENET_DATA_SEG + (8 * PAGE_SIZE), 0xC30001F3);
    SetPageMap(ENET_DATA_SEG + (9 * PAGE_SIZE), 0xC30001F2);
    SetPageMap(ENET_DATA_SEG + (10 * PAGE_SIZE), 0xC30001F1);
    SetPageMap(ENET_DATA_SEG + (11 * PAGE_SIZE), 0xC30001F0);
    SetPageMap(ENET_DATA_SEG + (12 * PAGE_SIZE), 0xC30001EF);
    SetPageMap(ENET_DATA_SEG + (13 * PAGE_SIZE), 0xC30001EE);
    SetPageMap(ENET_DATA_SEG + (14 * PAGE_SIZE), 0xC30001ED);
/* The last page is already there. */
/*  SetPageMap(ENET_DATA_SEG + (15 * PAGE_SIZE), 0xC30001EC); */
    MemoryInitialized = 1;
  }

EtherInit(address)
register short *address;
  {
    register short *addr = (short *) &EnetHostNumber;

    if (!MemoryInitialized) InitMemory();
    InitChip();
    InitEnetRead();
    *address++ = *addr++;
    *address++ = *addr++;
    *address++ = *addr++;
  }
    
InitChip()
  {
    register char *p;
    char *q;
    register long i;
    
    extern int nAsm_EnetInterrupt();
    register LocalControlBlockSegment *cbsr = lcbsp;
    register struct IAsetupblock *IAblock = &(lcbsp->IAsetupBlock);
    register struct SystemControlBlock *c = &lcbsp->scb;
    struct Configureblock *cbp = &lcbsp->cb;

    LastFrame = &(lcbsp->rfa[RECEIVE_BUFFERS]);
    
    *((int(**)()) (VECTOR_BASE + 0x06C)) = nAsm_EnetInterrupt;
    asm("andw #/F2FF,sr");
    asm("orw #/0200,sr");

    p = (char *) &EnetHostNumber;
    for (i = 2; i < 8; i++) *p++ = Fc3ReadBit8(i);

    /* power up the ethernet chip */
    scp = (struct SystemConfigurationPointer *) SCPADDR;
    scp->sysbus = 0;
    scp->ISCPlow = LOW(&lcbsp->iscp);
    scp->ISCPhigh = HIGH(&lcbsp->iscp);
    swabSmall(scp, sizeof(struct SystemConfigurationPointer));

    lcbsp->iscp.busy = 1;
    lcbsp->iscp.SCBoffset = 0;
    lcbsp->iscp.SCBlow = LOW(c);
    lcbsp->iscp.SCBhigh = HIGH(c);
    swabSmall(&lcbsp->iscp, sizeof(struct ISystemConfigurationPointer));

    c->command = 0;
    *(unsigned char *)ENETREG = 0;
    IntOccured = 0;
    Attention();
    while (IntOccured == 0);

    c->command = CUC_START;
    c->CBLoffset = Offset(cbp);
    swabSmall(c, sizeof(struct SystemControlBlock));
    cbsr->cb.status = 0;
    cbsr->cb.command = swap1(CONFIGURE + COM_EL + COM_INTERRUPT);
    cbsr->cb.link = 0xffff;
    cbsr->cb.c[0] = 0x080C;
    cbsr->cb.c[1] = 0x2E80;
    cbsr->cb.c[2] = 0x6000;
    cbsr->cb.c[3] = 0xf200;
    cbsr->cb.c[4] = 0x0001;
    cbsr->cb.c[5] = 0x0040;
    IntOccured = 0;
    Attention();
    while( IntOccured == 0);

    c->command = CUC_START;
    c->CBLoffset = Offset(IAblock);
    swabSmall(c, sizeof(struct SystemControlBlock));
    IAblock->command = sIACOMMAND;
    IAblock->link = 0xffff;
    IAblock->address = EnetHostNumber; /* don't swap the host # */
    Attention();
  }

int EtherReady()
  {
    return( IncomingFrame != NextFrame );
  }

char *EtherPeek()
  {
    return( (local_rbuf + ( (NextFrame - lcbsp->rfa) * ENET_MAX_DATA )) - 2 );
  };

EtherRead(bufptr)
register unsigned short *bufptr;
  {
    register unsigned long buf;
    register unsigned short count;

    if (NextFrame != IncomingFrame)
      {
	buf = NextFrame - lcbsp->rfa;
	count = (swap1(lcbsp->rbd[buf].count) & 0x3fff);
	*bufptr++ = lcbsp->rfa[buf].status;
	*bufptr++ = count;
	Copy(bufptr, (local_rbuf + (buf * ENET_MAX_DATA) ) - 2, count);
	EtherDrop();
      }
   }

EtherDrop()
  {
    register int buf, prev;

    buf = NextFrame - &lcbsp->rfa[0];
    prev = buf - 1;
    if (prev < 0) prev = RECEIVE_BUFFERS - 1;
    
    NextFrame->status = 0;
    NextFrame->buffer = 0xffff;
    NextFrame->command = 0x0080;
    lcbsp->rbd[buf].size |= 0x0080;
    lcbsp->rfa[prev].command = 0;
    lcbsp->rbd[prev].size &= 0xFF7f;
    if (++NextFrame == LastFrame) NextFrame = &lcbsp->rfa[0];
    if ((NextFrame == IncomingFrame) && (ReceiverNotReady == 1))
      {
	InitChip();
	InitEnetRead();
      }
  }

EnetSetFilter() {};
EnetNormalFilter() {};

char *EtherKind()
  {
    return("Sun 3");
  }

char statusbuf[128];
char *PrintEtherStatus(status)
register unsigned short status;
  {
    status = swap1(status);
    statusbuf[0] = 0;
    if (status & 0x0800) strcat(statusbuf, "CRC error ");
    if (status & 0x0400) strcat(statusbuf, "Alignment error ");
    if (status & 0x0200) strcat(statusbuf, "Resources error ");
    if (status & 0x0100) strcat(statusbuf, "DMA overrun ");
    if (status & 0x0800) strcat(statusbuf, "Packet too small ");
    if (status & 0x0400) strcat(statusbuf, "No EOF ");
    return(statusbuf);
  }

EtherBadStatus(status)
register unsigned short status;
  {
    return( (!status & 0x0020) ); /* swapped 0x2000 ( OK ) */
  }
