/*
 *
 *
 *   The 3com ether board definitions
 *		Bill Yeager 	May 24, 1983.
 *
 *                                           
 */
/*
 *	A macro to insure that we dont write 1's in upper 16 bits csr
 */
#define resetCSR(a,v) (*(a) = *(a) & (~v & 0xFF))
#define setCSR(a,v)   (*(a) = ((*(a) & 0xFF) | v))

# define DefaultBase 0x01E0000			/* What SMI Uses */
# define YeagerBase  0x01F2000			/* What Yeager@Sumex uses */

int MEBASE;		/* Determined at boot time */

#define MECSR  (short *)MEBASE			/* control and status reg */
#define MEBACK (short *)((int)MEBASE+2)		/* delay time reg(2's comp) */
#define MEROM  (short *)((int)MEBASE+0x400)	/* 48 bit station address */
#define MERAM  (short *)((int)MEBASE+0x600)	/* Addr stored here at init */
#define METRNX (short *)((int)MEBASE+0x800)	/* transmit buffer */
#define MERCVA (short *)((int)MEBASE+0x1000)	/* receive buffer A */
#define MERCVB (short *)((int)MEBASE+0x1800)	/* receive buffer B */
#define MEXHDR  METRNX				/* 1st word of transmit buf */
#define MEAHDR  MERCVA				/* 1st word of rcv buf A */
#define MEBHDR  MERCVB				/* 1st word of rcv buf B */

/* some CSR defintions */
/*   First the PA (programmable addresses) BITS 0 - 3 */
#define paALL          0
#define paALL_NE       1			/* reset range+fcs+frame */
#define paALL_Nf       2			/* reset fcs+frame */
#define paMine_Multi   3			/* RAM and multicast */
#define paMine_MultiNE 4			/* reset errors */
#define paMine_MultiNf 5			/* reset fcs+frame */
#define paMine_Broad   6			/* mine and broadcast */
#define paMine_BroadNE 7			/* reset errors */
#define paMine_BroadNf 8			/* reset fcs+frame */

/*  Next, CSR bits */
#define csJINTEN1 0x10				/* JAM enable  */
#define csTINTEN1 0x20				/* enable tx interrupt */
#define csAINTEN1 0x40
#define csBINTEN1 0x80				/* the enable input */
#define csRESET   0x100				/* reset the controller */
#define csRBBA    0x400				/* =1 if ABSW and BBSW are 0
					 	 *    and B arrived FIRST */
#define csAMSW1   0x800				/* Gives address loaded into
						 * the RAM to controller  */
#define csJAM0    0x1000			/* write 1 CLEARS JAM */
#define csTBSW1   0x2000			/* Gives tx buff to cntrl */
#define csABSW1   0x4000			/* A buff is controllers  */
#define csBBSW1   0x8000			/* B buff is controllers  */
#define BothActive (csABSW1+csBBSW1)		/* A & B buffer flags */

/* Now some masks for HDR stuff */
#define TXMSK    0x7FF				/* 11 bits for first byte 
						 *    offset into tx buff  */
#define RVMSK	 0x7FF				/* Masks NUMBER of first free
						 * byte in input buffer, ie,
						 * MEAHDR or MEBHDR, so its 
						 * value >> 1 is number of
						 * words in buffer
						 */

#define FrameError 	0x800			/* Input alignment error   */
#define OurAddress  	0x1000			/* address is station addr */
#define RangeError 	0x2000			/* Bad packet size         */
#define BroadPacket 	0x4000			/* packet is a broadcast   */
#define FcsError   	0x8000			/* frame check sequence err*/
