/*
 * char *QueryWorkstationConfig(keyword)
 *
 * Special hacked-up version for Vload.  Note nonstandard calling sequence.
 *
 * This routine provides a way for a program to discover details of
 *   the configuration of the workstation it is running on.  The keyword
 *   and return value are character strings.  Conceptually, the routine
 *   queries a database of configuration information, with the workstation's
 *   identity and the keyword as keys, and returns the associated value.
 *
 * The argument "keyword" is a pointer to a null-terminated character
 *   string.  The routine returns a pointer to the corresponding value,
 *   or NULL if none was found.
 *
 * The current implementation uses configuration files stored in the
 *   directory [public]config on public storage servers, with names formed
 *   from the (primary) Ethernet hardware address of the workstation.
 *
 * Tim Mann, 3/13/84:  Created.
 * TPM 3/20/84: Hacked up for Vload.
 */

#define MAX_CONFIG_SIZE 10000

#include <Vio.h>


char *ConfigBuff;
extern char HexEnetAddress[];
char configFileName[32] = "../config/C.";

ReadConfigFile(buffer)
    char *buffer;
  {
    /* Locate, open, and read in the proper config file */
    register File *f;
    SystemCode error;
    int size;

    ConfigBuff = buffer;

    /* Figure out which config file to read based on our 
     *   Ethernet address */
    strcat(configFileName, HexEnetAddress);
    puts("Loading ");
    puts(configFileName);
    puts("\n");

    f = Open(configFileName, FREAD+FBLOCK_MODE, &error);
    if (error != OK)
      {
	ConfigBuff = NULL;
	puts("Error reading ");
	puts(configFileName);
	return;
      }
#ifdef DEBUG
    puts(" reading... ");
#endif
    /* Assume instance is MULTI_BLOCK */
    size = Read(f, buffer, MAX_CONFIG_SIZE);
    buffer[size++] = 0;
    buffer[size] = -1;

#ifdef DEBUG
    puts("config file...");
#endif
    Close(f);
#ifdef DEBUG
    puts("closed\n");
#endif
  }


char *QueryWorkstationConfig(keyword)
    char *keyword;
  {
    register char *p, *q;

    if (ConfigBuff == NULL) return (NULL);

    q = ConfigBuff;
    /* Search for keyword.  We may put some '\0's in along the
     *   way, so when we see one we treat it just like a newline.
     *   It doesn't matter if we can't query the same keyword twice. */
    for (;;)
      {
	p = q;  /* Remember start of possible keyword */
	while (*q != ':' && *q != '\n' && *q != '\0' && *q != -1)
	    q++;

        if (*q == -1)	/* hit end of file while looking for keyword */
	    return (NULL);

	*q++ = '\0';

        if (strcmp(p, keyword) == 0) break;  /* found keyword */

	while (*q != '\n' && *q != '\0' && *q != -1)
	    q++;				/* skip to next keyword */

        if (*q++ == -1) 			/* pass over newline */
	    return (NULL);			/* or detect end of file */

      }


    /* Read the value (or as much as we have room for) */
    p = q;	/* Remember start of value */

    while (*q != '\n' && *q != -1 && *q != '\0')
	q++;

    *q = '\0';	/* don't bother looking for a continuation line */

    return (p);
  }
