/*
 * Distributed V Kernel - Copyright (c) 1982 by David Cheriton, Willy Zwaenepoel
 * (Transliterated from Zed and Verex Kernel)
 *
 * Process Descriptor, Team descriptor type definitions and related manifests
 *  Outdated version, hacked for use by Vload
 */


#ifndef PROCESS
#define PROCESS

#include <Venviron.h>
#include "Vprocess.h"

typedef struct _PD  /* Process Descriptor Record */
  {
	struct _PD	*link;		/* General-purpose queue link.  Must 
					   be first */
	Process_id	pid;		/* Process identifier */
	Process_id	old_pid;
	struct _PD	*father;	/* Pointer to PD of creator */
	struct _PD	*brother;	/* Pointer to next sibling */
	struct _PD	*son;		/* List of processes created */
	short		state;		/* Blocked state else ready */
	short		priority;	/* Processor allocation */
	/*Team		*team;		/* Team of process */
	Process_id	blocked_on;	/* Process or device blocked on */
	struct _PD	*forwarder;	/* PD of last sending process */
	MsgStruct	msg;
	struct _PD	*msg_queue;	/* Queue of messages waiting */
	struct _PD	*msg_queue_end;	/* Last PD in msg queue */
	Unspec		*returnMessage;	/* Address for Finish_up_arg */
	unsigned short	seqNo;		/* Sequence Number */
	unsigned short  moveIndex;	/* Next block to be moved */
	unsigned char	numTrans;	/* Number of retransmissions */
	unsigned char	dataSegmentPro; /* Data segment protection */
	Unspec		*dataSegmentPtr;/* Begin of datasegment */
	unsigned	dataSegmentSize;/* End of datasegment */
	Unspec		*dataExpected;	/* Next data expected for Moves */
	unsigned short  seqNoExpected;	/* Seq no of expected MoveTo group */
	Unspec		*remoteSegmentPtr;
	unsigned	remoteSegmentSize;
	unsigned	*recBufPtr;	/* Buffer for immediate receive */
	unsigned	*recBufSizePtr;	/* Address for size on immediate
					   receive */
	unsigned	recBufSize;	/* Size of buffer */
	Unspec		(*finish_up)();	/* Called when process unblocks */
	Processor_state  proc_state;	/* Processor state and per-process info */
  } Process;

/* dataSegmentPro bit fields */

#define READ_ACCESS		0x08
#define WRITE_ACCESS		0x04
#define SEGMENT_ACCESS		0x0C /* Segment if either READ or WRITE */

#endif
