/*
 * Miscellaneous junk for the V I/O protocol boot loader
 */

#include <Venviron.h>
#include <Vnaming.h>
#include <Vsession.h>

ProcessId DirectToCurrentContext(request)
    NameRequest *request;
  {
    Message msg;
    register LookupServerRequest *lrequest = (LookupServerRequest *) msg;
    register LookupServerReply *lreply = (LookupServerReply *) msg;
    ProcessId pid;
    char *name;

    /* Simulate local name server here */
    name = &(request->nameptr[request->nameindex]);
    if (*name == '[')
      {
	/* Grimy way to lookup server pids */
        pid = GetPid(UNIX_SERVER, ANY_PID);
	lrequest->requestcode = LOOKUP_SERVER;
	lrequest->hostname = ++name;
	lrequest->namelength = 0;
	while (*name && *name++ != ']')
	    lrequest->namelength++;

	request->nameindex += lrequest->namelength+2;
			/* advance past server name */

	Send(lrequest, pid);
	if (lreply->replycode == OK) 
	    pid = lreply->serverpid;
	else
	    pid = 0;
      }
    else
      {
        pid = GetPid(STORAGE_SERVER, ANY_PID);
      }

    request->namecontextid = PUBLIC_CONTEXT;
    return (pid);
  }

PutShortHex(i)
  {
    K_putchar(MakeHexDigit(i>>12));
    K_putchar(MakeHexDigit(i>>8));
    K_putchar(MakeHexDigit(i>>4));
    K_putchar(MakeHexDigit(i));
  }

MakeHexDigit(i)
    register int i;
  {
    i &= 0xF;
    if (i >= 10) 
	i += ('a' - 10);
    else
	i += '0';
    return (i);
  }


char *calloc(a, b)
  {
    register int bytes;
    register char *start;
    extern char *Arena;

    bytes = b;	/* assume a == 1 */
    start = Arena;

    while (bytes--) *Arena++ = 0;

    return (start);
  }

CopyBytes( dest, src, bytes ) register char *dest, *src;
                    register short bytes;
  /* Small but slow version */
  {
    if (bytes--) do
      {
	*dest++ = *src++;
      }
    while(--bytes != -1);
  }
