/*
 * Distributed V Kernel 
 * Copyright (c) 1982 by David Cheriton, Tim Mann, Willy Zwaenepoel
 *
 * Inter kernel communication routines
 * Minimal set needed for standalone bootstrap loader,
 *   hacked up to run in busy-wait mode (TPM 11/11/83)
 * Partly based on a similar hack done for SGI
 *
 */

#include "process.h"
#include <Vikc.h>
#include <Vethernet.h>
#include <Vioprotocol.h>
#include <Vgroupids.h>

#define	MAXTRANS		10
#define MAX_PACKET_DELAY	100

#ifdef DEBUG
#define debug(c) K_putchar(c)
#else
#define debug(c)
#endif DEBUG

extern Process *Active;

unsigned short 	CurrentSeqNo = 1;
extern kPacket	*kPacketSave;
extern SystemCode AwaitKernelPacket();
int PacketDelay;  /* number of packets not for us received since last
		   *   good packet in AwaitSendReply */

#define CopyMsg(to, from) CopyBytes(to, from, 32)


/* For sending the boot requests (CreateInstance and Read) to the
 *   storage server, we need Send().  This is really a modified
 *   NonLocalSend() since the local case is not needed. */
ProcessId Send ( msg, pid ) 
    register MsgStruct *msg;
    ProcessId pid;
  {
    register Process *pd, *prev;
    unsigned append;
    int WriteKernelPacket();
    SystemCode r;

debug('{');
    /* Adjust process state */
    pd = Active;
    CopyMsg(&pd->msg, msg);

    /* Check if there is segment associated with this message */
    if ( msg->sysCode & SEGMENT_PRESENT )
      {
        pd->dataSegmentPro = 
		(unsigned char)(msg->sysCode >> 8 );
        pd->dataSegmentPtr = (Unspec *) (msg->segmentPtr);
        pd->dataExpected = NULL;
        pd->dataSegmentSize = msg->segmentSize;
      }
    else
        pd->dataSegmentSize = 0;

    pd->forwarder = ( Process * ) pd->pid;
    pd->blocked_on = pid;
    pd->seqNo = CurrentSeqNo++;
    pd->state = AWAITING_REPLY;
    /* Send off packet */
    pd->numTrans = 0;
    while ( ++(pd->numTrans) < MAXTRANS )
      {
        if( (pd->dataSegmentPro & READ_ACCESS) &&
	    (pd->dataSegmentSize > 0 ) )
          {
	    if( pd->dataSegmentSize >= MAX_APPENDED_SEGMENT )
	        append = MAX_APPENDED_SEGMENT;
	    else
	        append = pd->dataSegmentSize;
	    WriteKernelPacket(remoteSend,pd->pid,pid,0,append,0,
		     	 NULL,pd->seqNo,msg,pd->dataSegmentPtr);
          }
        else
	    WriteKernelPacket(remoteSend,pd->pid,pid,0,0,NULL,
			 NULL,pd->seqNo,msg,NULL);
	if ( AwaitSendReply() == OK ) break;  /* got a reply */
debug('~');
      }
    if (pd->numTrans == MAXTRANS)
      {
	msg->sysCode = TIMEOUT;
debug('T');
      }
    else
	CopyMsg(msg, &pd->msg);		/* succeeded */

debug('}');
    return (pd->blocked_on);
  }

AwaitSendReply()
    /*
     * Busy wait, looking for a reply to a Send.
     * Also handle MoveTo/MoveFrom requests while waiting.
     */
  {
    extern kPacket *kPacketSave;
    ProcessId pRemoteReply();
    ProcessId pBreathOfLife();
    ProcessId pRemoteMoveFromReq();
    ProcessId pRemoteMoveToReq();
    ProcessId pRemoteReceiveSpecific();

    PacketDelay = 0;
    for (;;)
      {
	if (AwaitKernelPacket() != OK) return (TIMEOUT);

debug('a' + kPacketSave->packetType);

        switch (kPacketSave->packetType)
	  {
	  case remoteReply:
	    pRemoteReply();
	    if (Active->state == READY) return (OK);
	    break;

	  case breathOfLife:
	     pBreathOfLife();
	     break;

	  case remoteMoveFromReq:
	    pRemoteMoveFromReq();
	    break;

	  case remoteMoveToReq: 
	    pRemoteMoveToReq();
	    break;

	  case remoteReceiveSpecific:
	    pRemoteReceiveSpecific();
	    break;

	  }
        if( PacketDelay++ > MAX_PACKET_DELAY ) 
          {
debug('t');
	    return( TIMEOUT );
	  }
      }
  }



/* To pick up the server's replies */
ProcessId pRemoteReply()
  {
    register Process *pd;
    register kPacket *kp = kPacketSave;

    pd = Active;

    if ( ( pd->pid != kp->dstPid ) || ( pd->seqNo != kp->sequenceNo ) )
	return;
    pd->state = READY;
    CopyMsg( &pd->msg, &kp->msg );
    if( kp->length != 0 )
      {
	if( ((pd->dataSegmentPro & WRITE_ACCESS) == 0 ) ||
	    ((unsigned)pd->dataSegmentPtr > (unsigned)kp->remoteaddress)||
	    ((unsigned)kp->remoteaddress+kp->length >
	     (unsigned)pd->dataSegmentPtr+pd->dataSegmentSize) )
	    DiscardDataPacket( kp->length );
	else
	    ReadDataPacket( kp->length, kp->remoteaddress );  
      }
    return;
  }


/* Server might send this */
ProcessId pBreathOfLife()
  {
    register kPacket *kp = kPacketSave;
    register Process *pd = Active;

    if ( ( pd->pid == kp->dstPid ) && ( pd->seqNo == kp->sequenceNo ) )
      {
	pd->numTrans = 0;
	PacketDelay = 0;
      }
  }

 

/* In case server does a ValidPid.  This style of ValidPid is
 *   still used by the V server, but not by the kernel, which
 *   uses QueryProcessState.  We don't handle the latter. */
ProcessId pRemoteReceiveSpecific()
  {
    register kPacket *kp = kPacketSave;

    if ( kp->dstPid == Active->pid )
      {
        WriteKernelPacket ( breathOfLife,kp->dstPid,kp->srcPid,0,0,NULL, 
			NULL,kp->sequenceNo,NULL,NULL );
      }
  }


/* In case the server needs to retrieve a filename */
ProcessId pRemoteMoveFromReq()
  {
    Process *pd, *active;
    register kPacket *kp = kPacketSave;
    int WriteKernelPacket();
    int lengthLeft;

    pd = Active;
    if ( (pd->pid != kp->dstPid) ||
         (pd->state != AWAITING_REPLY) ||
         (pd->blocked_on != kp->srcPid) ||
	 ((pd->dataSegmentPro & READ_ACCESS) == 0) ||
         ((unsigned)pd->dataSegmentPtr > (unsigned)kp->remoteaddress) ||
         ((unsigned)kp->remoteaddress+kp->length > 
	  (unsigned)(pd->dataSegmentPtr)+pd->dataSegmentSize) ) 
      {
        return;
      }

    pd->numTrans = 0;	/* Reset transmissions counter */
    PacketDelay = 0;
    lengthLeft = kp->length;
    while (lengthLeft > MAX_APPENDED_SEGMENT)
      {
        WriteKernelPacket(remoteMoveFromReply,kp->dstPid,kp->srcPid,
		  0,MAX_APPENDED_SEGMENT,kp->length,
		  kp->localaddress,kp->sequenceNo,NULL,kp->remoteaddress);
        kp->localaddress = (Unspec *)((unsigned)(kp->localaddress) 
		+ MAX_APPENDED_SEGMENT);
        kp->remoteaddress = (Unspec *)((unsigned)(kp->remoteaddress) 
		+ MAX_APPENDED_SEGMENT);
	lengthLeft -= MAX_APPENDED_SEGMENT;
      }
    if( lengthLeft != 0 )
      {
        WriteKernelPacket(remoteMoveFromReply,kp->dstPid,kp->srcPid,
		  0, lengthLeft,kp->length,
		  kp->localaddress,kp->sequenceNo,NULL,kp->remoteaddress);
      }
  }
   

/* This allows the server to load stuff into our memory */
ProcessId pRemoteMoveToReq()
  {
    Process *pd, *active;
    register kPacket *kp = kPacketSave;
    int ReadDataPacket(), DiscardDataPacket();
    /* kp->remoteaddress is a local address,
       kp->localaddress is the total length */

    pd = active = Active;
    if ( (pd->pid != kp->dstPid) ||
	 (pd->state != AWAITING_REPLY) ||
	 ((pd->dataSegmentPro & WRITE_ACCESS) == 0) ||
	 (kp->remoteaddress < pd->dataSegmentPtr) ||
         ((unsigned)kp->remoteaddress+kp->length > 
	  (unsigned)(pd->dataSegmentPtr)+pd->dataSegmentSize) )
      {
debug('#');
        DiscardDataPacket( kp->length );
        return;
      }

    pd->numTrans = 0; /* Reset transmission counter */
    PacketDelay = 0;

    /* Sequencing check */
    if( pd->dataExpected == NULL ||		/* new MoveTo group */
	kp->sequenceNo != pd->seqNoExpected ||
        kp->remoteaddress < pd->remoteSegmentPtr )
      {
	pd->seqNoExpected = kp->sequenceNo;
        pd->remoteSegmentPtr = pd->dataExpected = kp->remoteaddress;
        pd->remoteSegmentSize = (unsigned) kp->localaddress;
      }

    if( kp->remoteaddress == pd->dataExpected )
      {
        pd->dataExpected = (Unspec *)((unsigned)pd->dataExpected+kp->length);
        ReadDataPacket( kp->length, kp->remoteaddress );

        /* Check if done */
        if((unsigned)pd->dataExpected ==
	   (unsigned)pd->remoteSegmentPtr + pd->remoteSegmentSize)
	  {
	    pd->dataExpected = NULL;
	    WriteKernelPacket(remoteMoveToReply,kp->dstPid,kp->srcPid,
			      0,pd->remoteSegmentSize,pd->remoteSegmentPtr,
			      NULL,kp->sequenceNo,NULL,NULL);
  	  }
      }
    else
      {
debug('?');
        DiscardDataPacket( kp->length );
      }
  }

ProcessId GetPid ( logical_id, scope )
register unsigned logical_id;
  {
    KernelRequest msg;
    register KernelRequest *req = &msg;

    req->opcode = GET_PID;
    req->pid = 0;
    req->unspecified[0] = logical_id;
    req->unspecified[1] = scope;
    Send( req, VKERNEL_SERVER_GROUP );
    if ( req->opcode != OK )
{
puts("GetPid failed.\n");
return( 0 );
}
    return( req->pid );
  }
