/*
 * getvalue.c
 *
 * Get the proper value for a command argument following the procedure
 *   described in action.h.
 *
 * The arguments are as follows:
 *   value	Character array to put the result in.
 *   arg	Command line arg if any.
 *   action	Pointer to action table entry.
 *   keyword	Keyword to look at in QueryWorkstationConfig.
 *   defalt	Default if no value for this keyword.
 *
 * Sorry about the gotos.  They save a little space.
 */

#ifdef DEBUG
#define debug(c) K_putchar(c)
#else
#define debug(c)
#endif

#include "action.h"
#include <Vio.h>

extern char *QueryWorkstationConfig();

GetValue(value, arg, action, keyword, defalt)
    char *value, *arg, *action, *keyword, *defalt;
  {
    char *temp;

    /* The command line argument, if any, has first priority */
    if (arg != NULL)
      {
	temp = arg;
	goto done;
      }

    /* No command line argument.  Action table entry has second priority */
    if (action != NULL)
      {
#ifndef NDBOOT
	if (*action == '?')
	  {
	    puts(++action);
#ifdef LOTS_OF_ROOM
	    if ((temp = QueryWorkstationConfig(keyword)) == NULL)
	      {
		/* No value for the config keyword.  Use the default. */
		temp = defalt;
	      }
	    if (temp)
	      {
	        puts("(");
		puts(temp);
		puts(") ");
	      }
#endif LOTS_OF_ROOM
	    gets(value);
	    if (*value != '\0') return;
	  }
	else
#endif NDBOOT
	  {
	    temp = action;
	    goto done;
	  }
      }

    /* Hmm, no action table entry.  Need to do a QueryWorkstationConfig */
    if ((temp = QueryWorkstationConfig(keyword)) == NULL)
      {
	/* No value for the config keyword.  Use the default. */
	temp = defalt;
      }

done:
    strcpy(value, temp);

  }
