
#include "process.h"
#include "Vethernet.h"
#include "Vikc.h"
#include "enet50.h"
#include

#define RECEIVE_BUFFERS 10
#define MAXLOOPCOUNT 500000

#ifdef DEBUG
#define debug(c) K_putchar(c)
#else
#define debug(c)
#endif

#define CopyMsg(to, from) CopyBytes(to, from, sizeof(MsgStruct))
#define Offset(addr) ((unsigned short)(((long)(addr))-((long)&(cbs.scb))))
/*#define Address(offset) ((char *) (((long)offset) + (long)&(cbs.scb)))*/

unsigned short swap1();

struct SystemConfigurationPointer *scp;
struct ISystemConfigurationPointer iscp;
/* Control Block Segment */
struct ControlBlockSegment
  {
    struct SystemControlBlock scb;
    struct IAsetupblock IAsetupBlock;
    struct Transmitblock xblock;
    struct TransmitBufferDescriptor tbd;
    struct ReceiveFrameDescriptor rfa[RECEIVE_BUFFERS];
    struct ReceiveBufferDescriptor rbd[RECEIVE_BUFFERS];
  } cbs;

char xbuf[ENET_MAX_DATA];
char rbuf[RECEIVE_BUFFERS][ENET_MAX_DATA];

char HexEnetAddress[sizeof(NetAddress)*2 + 1];

NetAddress EnetHostNumber;

EnetBlock *EnetPacket;

kPacketWithSegment *kPacketSave;
Enet10Address ServerHostAddress;
int ServerLogicalHost = -1;
NetAddress	BroadcastAddress = { 0xFFFF, 0xFFFF, 0xFFFF };
int KernelPacketType = V_KERNEL_PACKET;
int IntOccured;
int LastStatus;
struct ReceiveFrameDescriptor *IncomingFrame, *NextFrame;

Attention()
  {
    *(unsigned char *)ENETREG = (unsigned char) I_CA+I_LOOPB+I_RESET+I_INTEN;
    asm("nop");
    asm("nop");
    *(unsigned char *)ENETREG = (unsigned char) I_LOOPB+I_RESET+I_INTEN;
    while (cbs.scb.command != 0); /* Wait for command to be accepted */
  }

asm("    .text");
asm("    .globl Asm_EnetInterrupt");
asm("    Asm_EnetInterrupt:");
asm("    orw	#/0700,sr");
asm("	 moveml	#/c0c0,sp@-");		/* Save d0,d1,a0,a1 */
asm("    jbsr	EnetInterrupt");
asm("    andw	#/F2FF,sr");
asm("	 orw	#/0200,sr");
asm("	 moveml	sp@+,#/0303");		/* Restore registers */
asm("	 rte");				/* Return */

EnetInterrupt()
  {
    register struct SystemControlBlock *c = &cbs.scb;
    
    if (c->status & sFR) IncomingFrame++;
    c->command = c->status & sACK_MASK; /* Acknowledge */
    c->CBLoffset = 0xFFFF; /* palindrome - no need to swap this */
    Attention();
    IntOccured = 1;
  }

SystemCode EnetPowerup()
  {
    extern Process *Active;
    register char *p;
    char *q;
    register long i;
    
    extern int Asm_EnetInterrupt();
    register struct ControlBlockSegment *cbsr = &cbs;
    register struct IAsetupblock *IAblock = &(cbs.IAsetupBlock);
    register struct SystemControlBlock *c = &cbs.scb;

    *((int(**)()) 0x06C) = Asm_EnetInterrupt;
    asm("andw #/F2FF,sr");
    asm("orw #/0200,sr");

    p = (char *) &EnetHostNumber;
    for (i = 0x1008; i < 0x4008; i += 0x800)
	*p++ = Fc3ReadBit8(i);

    Active->pid = ((K_ticks()<<16) + 0xbead) & ~LITTLE_ENDIAN_HOST;
    /* Convert to hex for use elsewhere */
    p = (char *) &EnetHostNumber;
    q = HexEnetAddress;
    for (i=0; i<sizeof(EnetHostNumber); i++)
      {
	*q++ = MakeHexDigit((*p)>>4);
        *q++ = MakeHexDigit(*p++);
      }
    *q = '\0';
   
    /* power up the ethernet chip */
    scp = (struct SystemConfigurationPointer *) SCPADDR;
    scp->sysbus = 0;
    scp->ISCPlow = LOW(&iscp);
    scp->ISCPhigh = HIGH(&iscp);
    swabSmall(scp, sizeof(struct SystemConfigurationPointer));

    iscp.busy = 1;
    iscp.SCBoffset = 0;
    iscp.SCBlow = LOW(c);
    iscp.SCBhigh = HIGH(c);
    swabSmall(&iscp, sizeof(struct ISystemConfigurationPointer));

    c->command = 0;

    *(unsigned char *)ENETREG = 0;
    IntOccured = 0;
    Attention();
    while (IntOccured == 0);

    c->command = CUC_START;
    c->CBLoffset = Offset(IAblock);
    swabSmall(c, sizeof(struct SystemControlBlock));

    IAblock->command = sIACOMMAND;
    IAblock->link = 0xffff;
    IAblock->address = EnetHostNumber; /* don't swap the host # */
    IntOccured = 0;
    Attention();
    while(IntOccured == 0);
  }

SystemCode AwaitKernelPacket()
  {
    long i;
    register int buf;

    i = MAXLOOPCOUNT;
    while (--i != 0)
	if (NextFrame < IncomingFrame)
	  {
buf = NextFrame - cbs.rfa;
#ifdef undef
K_putchar('a' + buf);
#endif
	    if (NextFrame->type == KernelPacketType)
	      {
		kPacketSave = (kPacketWithSegment *)rbuf[buf];
		ServerHostAddress = NextFrame->source;
		if (DifferentIKCByteOrder(kPacketSave))
		  {
		    SwapIKPacket(kPacketSave);
		  }
		kPacketSave->packetType &= ~IKC_LITTLE_ENDIAN;
		ServerLogicalHost = (kPacketSave->srcPid)>>16;
		NextFrame++;
		return ( OK );
	      }
	    NextFrame++;
	  }
    return( TIMEOUT );
  }

extern int WriteKernelPacket(type, srcPid, dstPid, forwarder, length,
			localaddress,remoteaddress,sequenceNo, msg, data )	
  short	type;
  ProcessId srcPid, dstPid, forwarder;
  unsigned int length;
  Unspec *localaddress;
  Unspec *remoteaddress;
  unsigned short sequenceNo;
  MsgStruct *msg;
  unsigned char *data;
  {
    register kPacketWithSegment *packet = (kPacketWithSegment *) xbuf;
    register struct ControlBlockSegment *c = &cbs;
    register struct ReceiveFrameDescriptor *f = cbs.rfa;
    register struct ReceiveBufferDescriptor *r = cbs.rbd;
    register int i;

    NextFrame = IncomingFrame = f;
    
    c->scb.command = CUC_START + RUC_START;
    c->scb.CBLoffset = Offset(&(c->xblock));
    c->scb.RFAoffset = Offset(f);
    swabSmall(&(c->scb), sizeof(struct SystemControlBlock));

    for(i = 0; i<RECEIVE_BUFFERS; i++, f++, r++)
      {
	if (i == 0)
	    f->buffer = Offset(r);
	else
	    f->buffer = 0xffff;
	f->command = 0;
	f->link = Offset(f+1);
	r->size = ENET_MAX_DATA;
	r->count = 0;
	r->next = Offset(r+1);
	r->bufferlow = LOW(rbuf[i]);
	r->bufferhigh = HIGH(rbuf[i]);
	if (i == RECEIVE_BUFFERS-1)
	  {
	    f->command = 0x8000; /* end of list */
	    r->size |= 0x8000;
	  }
	swabSmall(f, sizeof(struct ReceiveFrameDescriptor));
	swabSmall(r, sizeof(struct ReceiveBufferDescriptor));
      }
    
    c->xblock.TBDoffset = swap1(Offset(&c->tbd));
    c->xblock.command = sTRANSMIT;
    c->xblock.type = KernelPacketType;
    if ( (dstPid>>16) == ServerLogicalHost)
        c->xblock.destination = ServerHostAddress;
    else
        c->xblock.destination = BroadcastAddress;

    c->tbd.count = 0x8000 + sizeof(kPacket);
    if (data != NULL) c->tbd.count += length;
    c->tbd.bufferlow = LOW(xbuf);
    c->tbd.bufferhigh = HIGH(xbuf);
    swabSmall(&(c->tbd), sizeof(struct TransmitBufferDescriptor));
 
    packet->packetType = type & ~IKC_LITTLE_ENDIAN;
    packet->sequenceNo = sequenceNo;
    packet->srcPid = srcPid;
    packet->dstPid = dstPid;
    packet->forwarder = forwarder;
    packet->userNumber = 0;		/* user number */
    packet->length = length;
    packet->localaddress = localaddress;
    packet->remoteaddress = remoteaddress;
    if( msg != NULL )
	CopyMsg(&packet->msg, msg);
    if( data != NULL )
	CopyBytes( packet->data, data, length );

    IntOccured = 0;
    Attention();
    while (IntOccured == 0);

    return (OK);
  }


int ReadDataPacket ( bytes, dst )
    unsigned bytes; 
    unsigned char *dst;
  {
    CopyBytes( dst, kPacketSave->data, bytes );
    return( OK );
  }

int DiscardDataPacket ( bytes ) unsigned bytes;
  {
    return( OK );
  }

unsigned short swap1(y)
register int y;
  {
    register int z;
    asm("andl #65535,d7");
    asm("movl d7,d0");
    asm("asrl #8,d0");
    asm("asll #8,d7");
    asm("addl d7,d0");
    asm("andl #65535,d0");
  }
