/*
 * Distributed V Kernel 
 * Copyright (c) 1982 by David Cheriton, Tim Mann, Willy Zwaenepoel
 *
 * Kernel Ethernet driver
 * Hacked into a standalone version for the bootstrap loader,
 *   11/11/83 by TPM.
 */

#include "process.h"
#include "Vethernet.h"
#include "Vikc.h"
#include "enet3com.h"
#define MAXLOOPCOUNT 200000

#ifdef DEBUG
#define debug(c) K_putchar(c)
#else
#define debug(c)
#endif DEBUG

#define CopyMsg(to, from) CopyBytes(to, from, 32)

/* Exports */
extern SystemCode EnetPowerup();
extern SystemCode AwaitKernelPacket();
extern int WriteKernelPacket();
int KernelPacketType = V_KERNEL_PACKET;
char HexEnetAddress[sizeof(NetAddress)*2 + 1];

NetAddress	EnetHostNumber;		/* physical ethernet address */
short		EnetCollisions = 0;	/* Number of collision errors */
EnetBlock	*EnetPacket;
kPacketWithSegment
		*kPacketSave;		/* Save area for kernel packets */

NetAddress	ServerHostAddress;	/* A one-address "cache" */
int		ServerLogicalHost = -1;

NetAddress	BroadcastAddress = { 0xFFFF, 0xFFFF, 0xFFFF };


ProcessId GetFakePid()
  /* Make up a process ID to use for the loader.
   * Also initializes the Ethernet address. */
  {
    extern Process *Active;
    register int i;
    register char *p, *q;

    EnetHostNumber = *(NetAddress *)MEADRAM = *(NetAddress *)MEADROM;

    /* Convert to hex for use elsewhere */
    p = (char *) &EnetHostNumber;
    q = HexEnetAddress;
    for (i=0; i<sizeof(EnetHostNumber); i++)
      {
	*q++ = MakeHexDigit((*p)>>4);
        *q++ = MakeHexDigit(*p++);
      }
    *q = '\0';

    return ( Active->pid = ((K_ticks()<<16) & ~LITTLE_ENDIAN_HOST)
				 + 0xbead );
  }


SystemCode EnetPowerup()

  /*  Powerup and initialize the Ethernet Interface Board.
   */
  {
    register int count;
    
    /* Clear all interrupts, flush all buffers */
    *(short *)MECSR = RESET;

    /*
     * Read Ethernet address of this host from the On-board PROM
     * and put it in the Address RAM.  Flick the AMSW bit in
     * MECSR to give the controller its address
     */

    GetFakePid(); /* Set network address as a side-effect */

    *(short *)MECSR = AMSW;	/* Give the ME its address */

    /*
     * Establish the ME receive criteria, and hand it both 
     * receiver buffers
     */

    *(short *)MECSR |= (RXMODE | ABSW | BBSW);

    return( OK );
 }


static short mecsr = 0;

SystemCode AwaitKernelPacket()

   /* Wait until a valid kernel packet is received.  Return
    *   TIMEOUT if we time out before getting one.
    */
  {
    register unsigned	words, readwords, bytes;
    register short	*p;
    short		status;
    short		*save, *foo, *mehdr;
    SystemCode		ret;
    register int	loopcount = 0;

debug('a');
    if (mecsr)
      {
	*(short *) MECSR |= mecsr;
        mecsr = 0;
debug('b');
      }

    /* Find a valid error-free packet */
    while (loopcount++ < MAXLOOPCOUNT )
      {
	switch( (*(short *)MECSR & (ABSW | BBSW)) >> 14 )
	  {
        case 0:	/* Both have a packet, take the first one received */
		if(*(short *)MECSR & RBBA)
		    goto ReadB;
		else
		    goto ReadA;

	case 1:	/* Receive buffer B has packet */
	ReadB:
		mehdr = (short *) MEBHDR;
		mecsr = BBSW;
		break;
	case 2: /* Receive buffer A has packet */
	ReadA:
		mehdr = (short *) MEAHDR;
		mecsr = ABSW;
		break;
	case 3: /* Both are empty */
		continue;
          }
debug('c');
	bytes = (*mehdr & 0x7FF) - 2;
	words = (bytes+1) >> 1;

	if( (*mehdr & (FCSerr|FRAMerr|RANGerr)) == 0 )
	  {
debug('d');
	    /* A valid packet */

	    /* Get the first two words of the packet and figure out
	       if it is a kernel packet */
	    EnetPacket = (EnetBlock *) (mehdr + 1);
	    kPacketSave = (kPacketWithSegment *) EnetPacket->data;
	    if( EnetPacket->EtherType == KernelPacketType )
	      {
		ServerHostAddress = EnetPacket->SrcHost;
		if (DifferentIKCByteOrder(kPacketSave))
		  {
		    SwapIKPacket(kPacketSave);
		  }
		kPacketSave->packetType &= ~IKC_LITTLE_ENDIAN;
		ServerLogicalHost = (kPacketSave->srcPid)>>16;
		return (OK);
	      }
          }
debug('e');
	*(short *) MECSR |= mecsr;  /* toss packet */
      }
debug('f');
    return( TIMEOUT );
  }


/* Routines specific to the distributed version */


extern int WriteKernelPacket(type, srcPid, dstPid, forwarder, length, localaddress,
				remoteaddress,sequenceNo, msg, data )	

/* Writes kernel packet to the Ethernet */

  short		type;
  ProcessId	srcPid, dstPid, forwarder;
  unsigned int	length;
  Unspec	*localaddress;
  Unspec	*remoteaddress;
  unsigned short	sequenceNo;
  long		*msg;
  unsigned char *data;
  {
    EnetBlock *enetpacket;
    register kPacketWithSegment *packet;
    register unsigned bytes;
    register int dstLogicalHost;

    EnetCollisions = 0;

    /* Make sure packet data starts on an even byte boundary in
	the ethernet board's packet buffer */
    if (data != NULL)
	bytes = (length + 1) & ~1;
    else
	bytes = 0;

    enetpacket = (EnetBlock *) ( SENDEND - sizeof(kPacket) - 14 - bytes );

    dstLogicalHost = dstPid>>16;
    if (dstLogicalHost == ServerLogicalHost)
        enetpacket->DestHost = ServerHostAddress;
    else
        enetpacket->DestHost = BroadcastAddress;

    enetpacket->SrcHost = EnetHostNumber;
    enetpacket->EtherType = KernelPacketType;
    packet = (kPacketWithSegment *) enetpacket->data;
    packet->packetType = type & ~IKC_LITTLE_ENDIAN;
    packet->sequenceNo = sequenceNo;
    packet->srcPid = srcPid;
    packet->dstPid = dstPid;
    packet->forwarder = forwarder;
    packet->userNumber = 0;		/* user number */
    packet->length = length;
    packet->localaddress = localaddress;
    packet->remoteaddress = remoteaddress;
    if( msg != NULL ) CopyMsg(&packet->msg, msg);
    if( data != NULL )
	CopyBytes( ((kPacketWithSegment *)packet)->data, data, length );

transmit:	
    *(short *)METXHDR = (short)((unsigned)enetpacket - (unsigned)METXHDR);
    
    *(short *)(MECSR) |= (RXMODE | TBSW);

    while ( *(short *)MECSR & TBSW )  /* while still transmitting */
	if ( *(short *)MECSR & JAM )  /* if collision */
	    TryEnetTransmit();

    return (OK);

  }

int ReadDataPacket ( bytes, dst )
    unsigned bytes; 
    unsigned char *dst;
  {
    CopyBytes( dst, kPacketSave->data, bytes );
    return( OK );
  }

int DiscardDataPacket ( bytes ) unsigned bytes;
  {
    return( OK );
  }

TryEnetTransmit()
{
if( *(short *)(MECSR) & JAM )
  {
    if (++EnetCollisions > 10)
      {
	*(short *)(MECSR) = RESET;
	*(short *)(MECSR) = (RXMODE|ABSW|BBSW);
      }
    else
      {
	unsigned short delay;

        /* C library routine rand() */

	delay = rand();
	delay = ((delay<<(16-EnetCollisions))>>16-EnetCollisions);
        *(short *)(MEBACK) = delay;
        *(short *)(MECSR) |= (RXMODE | JAM );
      }
  }
}

#ifdef undef
/* This is a quick hack to print out addresses - Lance */
puthex(addr)
register unsigned long addr;
  {
    char s[2];
    register int i;
    register char *c = s;
    *(c+1) = 0;
    for (i = 0; i < 8; i++)
      {
    	*c = "0123456789abcdef"[addr>>28];
    	puts(s);
    	addr <<= 4;
      }
  }
#endif
