/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1984			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

#include <Vioprotocol.h>

#define TRUE 1
#define FALSE 0
#define BlockSize 0x1000	/* buffer size for writes to a VGT (4K) */
#define MaxVGT 32		/* Max VGT's that the vgts can handle. */
#define MaxEvents 32		/* Max number of queued events */
#define DirectoryInstance (MaxVGT-1)
				/* special instance ID for directory I/O */
#define LineBufferSize 256	/* maximum characters in a "line" */

extern ProcessId VgtsPid;


/* Descriptor for a Virtual Graphics Terminal, */
typedef struct VGTDescriptor
  {
    /* information related to maintaining a VGT */
    int type;  /* Type of display - TTY, GRAPHICS, or GRAPHICS+ZOOMABLE */
    DisplayRecord *topSymbol;
		/* Ptr into the Structured Display File for the top symbol
		 * displayed in this VGT. */
    char *banner;
    BannerState	bannerState;	/* state of banner */
    char name[VGTnameLength];
  } VGT;

extern VGT VGTtable[];


struct Client
	/*
	 * Descriptor for an applications client.  Contains queues
	 * of input characters and mouse
	 * clicks and flags for indicating the state of a client's
	 *  requests. 
	 */
  {
    struct InterpUser *interp;
    ProcessId reader;		/* Process id of the client reading */
    ProcessId writerPid;	/* Process id of blocked writer, if any */
    ProcessId owner;		/* Delete it when this guy dies */
    ProcessId termPid;		/* pid of process to destroy on break input. */
    int requestFlag;		/* see bit definitions below */
    struct Event *eventQ;	/* event queue */
    struct Event *eventTail;
    struct Buffer *lineEditBuf;
    short isexec;		/* this info goes with view manager */
    short execid;
    short vgt;			/* pad for input to go to */
    short master;		/* master vgt if we are a slave */
    int BlockNumber;		/* Block number of the last write */
    int TotalBytesWritten;	/* Accumulated write byte count */
    int bytesWritten;		/* actual # bytes written when a write blocks */
    int lastBytesWritten;	/* # bytes written on the most recent attempt */
    MsgStruct reqMessage;	/* request msg, saved only if a write blocks */
    int mode;			/* mode bits (echo etc.) */
    int outputFlag;		/* see bit definitions below */
  };

extern struct Client ClientTable[];	/* the client table */


/* The following definitions are for source code compatibility between the
 * two versions of the VGTS.  When these two VGTSs are finally merged into
 * one, these should be removed, and the appropriate .c files changed back.
 */
typedef struct Client Term1;
#define Term1Table ClientTable
#define padPtr(term1) (TtyPadList+term1->vgt)
#define term2Ptr(term1) term1
typedef struct Client Term2;



/* fillers for requestFlag of each client.
 * The BlockBits are true if the pid is blocked awaiting
 * reply on the given type of event.  
 */
#define Keyreq		1
#define Mousereq	2
#define BlockBits 	(Keyreq|Mousereq)
#define SlaveReq	4

/* fillers for outputFlag of each client. */
#define PageOutputShutdown	1	/* quit PageOutput when user clears */


/* Line buffer for line editing on input */
struct Buffer
  {
  	/*
	 * temporary line buffer
	 */
    short count;		/* number of valid chars */
    short column;		/* current column */
    short escapeMode;		/* escape character */
    char c[LineBufferSize];	/* actual line buffer */
  };

/* input event descriptor */
struct Event
  {
    struct Event *next;		/* link */
    struct Event *editPrev;	/* backward link */
 /* Caution: Must be in the same order as EventReq in Vgts.h */
#ifndef LITTLE_ENDIAN
    short 	requestcode;
    short 	fileid;
    short 	code;		/* kind of event */
    short 	x;		/* for mouse events - otherwise fileid etc. */
    short 	y;
    short	buttons;
#else LITTLE_ENDIAN
    short 	fileid;
    short 	requestcode;
    short 	x;
    short 	code;		/* kind of event */
    short	buttons;
    short 	y;
#endif LITTLE_ENDIAN
    char shortbuffer[IO_MSG_BUFFER];
    unsigned bytecount;		/* number of chars in the buffer */
  } 
    EventTable[MaxEvents];

/* special End-of-file event code */
#define EOFcode 0x8000


/* Internal message codes, sent by helper processes to the main process */
enum MessageKind
  { 
  	Timer, 			/* a timer for blinking the cursor */
	Keyboard, 		/* a character was typed */
	GraphicsHelperMsg	/* contains a graphics event */
  };


/*
 * Descriptor for a viewport on the terminal's screen.
 * It contains the world and screen coordinates together
 * with a few constants to aid in the fast reconstruction
 * of the view when the display is updated.
 */
typedef struct viewPort
  {
    short ScreenXmin, 
          ScreenXmax, 
          ScreenYmin, 
	  ScreenYmax;
			/* Bounding screen coordinates for this viewport */
		 		   
    short WorldXmin, WorldXmax, WorldYmin, WorldYmax;
				/* World coordinates that this window is
				   currently mapped to. */
    short Xconst, Yconst;
    short zoom;			/* Magnification factor for this window. */
    short usage;		/* Type of graphics display being viewed
				   in this window - see usage-type defs. */
    short vgt;			/* Index of VGT which this view is showing. */
    short ViewID;		/* viewport Identifier */ 
    BOOLEAN showGrid;		/* Indicates if a grid pattern should be
		 		   shown in this window. */
    short expansionDepth;	/* how far to expand symbols */
    struct SubView *object;	/* rectangle list for object */
    struct SubView *rect;	/* rectangle list for banner */
    char *banner;		/* text of banner */
    BannerState	bannerState;	/* state of banner */
    struct viewPort *next;	/* link in front to back list */
  } View, *View_PTR;

extern View ViewTable[];

View *ViewList;		/* front to back list */

/* Overlapped views may be broken up into several rectangular visible
 * regions.  Each SubView describes one of these.  SubViews of one viewport
 * are linked together in a list: all are redrawn to redraw the viewport.
 */
struct SubView
  {
    short ScreenXmin, ScreenXmax, ScreenYmin, ScreenYmax;
    struct SubView *next;
    short EdgeSet;
    short bannerFlag		/* true if banner instead of object */
  };


#define FontHeight 16
#define FontWidth 8
#define BannerHeight 16

#define PageMessage		" Type <space> for next page "
#define PageMessageWidth	28 * FontWidth

/* margin of error on picking items */
#define MaxPixelMiss 8
