/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * sdf.h - private declarations for the Virtual Graphics Terminal Server
 *
 * Bill Nowicki August 1982
 */

/* Size definitions */

#define MAX_Views 32		/* maximum number of views */
#define NumberSDF 16		/* maximum number of SDFs */
#define VGTnameLength 52	/* maximum length of a VGT name (so sizeof vgt
				   is a power of two) */

/* The basic data type in the structured display file is the display_record
   defined below.  It contains pointers to other display records for
   structuring purposes, x and y coordinates for a bounding box for this
   item, a copy of the name used by the host program to identify this item,
   the type of the item (rectangle, point, symbol call, text, etc.), and 
   a few bits for any extra information needed by this type of record.  */

typedef struct display_record
  {
    struct display_record *rightSib,*leftChild;
    short item;		    /* item number */
    unsigned char type;     /* item type */
    unsigned char typedata; /* poly-whatever point count or attribute value */
    short x, y;		    /* position points, given by client */
    short xmin, ymin, xmax, ymax; /* bounding box, computed by vgts */
  } DisplayRecord;


/* String descriptor for General Text, used as leftChild of DisplayRecord */

typedef struct
  {
    short xskip;	/* delta(origin, xLeft of bounding box) */
    short descent;	/* delta(baseline, yBottom of bounding box) */
    short length;	/* in characters */
    char *string;	/* actual text */
  } TextStructure;

typedef enum
  {
    DisplayString,
    DisplayPageMessage
  }  BannerState;


typedef struct SdfTableRec
	/* Descriptor for a Structured Display File */
  {
    int type;			/* Type of sdf - only used and unused now */
    int openXmin, openXmax,
        openYmin, openYmax;	/* Bounding box of symbol being built */
    int redrawXmin, redrawXmax,
        redrawYmin, redrawYmax;	/* Bounding box of changes in edited symbol */
    DisplayRecord 
          *definingSymbol, 	/* the symbol we are defining */
          *currentItem,		/* the last item we added */
	  *addList;		/* list of added items */
    int needToClear;		/* true if deletes or changes were done */
    short outlineFlag;	        /* >0 if we can apply outline optimization */
    short *markers[MAX_MARKER_TYPE_INDEX]; /* marker type definitions */
    short *patterns[MAX_FILL_PATTERN_INDEX]; /* fill pattern definitions */
    short fonts[MAX_FONT_INDEX];/* external->internal font number translation */
  } SdfTableType;

extern SdfTableType SdfTable[];


#define Max(i, j) ( ( (i) > (j) ) ? (i) : (j) )

/*
 * special internal SDF type codes.
 * WARNING: must be disjoint from those give in Vgts.h!!!
 */

#define SDF_InternalText 80	/* overwriting text, for pads */
#define SDF_UpLine 81		/* lines from (xmin,ymin) to (xmax,ymax) */
#define SDF_DownLine 82	/* lines from (xmin,ymax) to (xmax,ymin) */
#define SDF_MaxCode 83
#define SDF_FREE 255

#define CMR_Font 8		/* magic index for default pad font */
#define Menu_Font 7		/* magic number for pop-up menu font*/
#define MENU_FONT_NAME "TimesRoman12B"
#define PAD_FONT_NAME "text_ss"

typedef function();
