/************************************************/
/*						*/
/*	       (C)  COPYRIGHT 1983		*/
/*		BOARD OF TRUSTEES		*/
/*	LELAND STANFORD JUNIOR UNIVERSITY	*/
/*	  STANFORD, CA. 94305, U. S. A.		*/
/*						*/
/************************************************/
 
/*
 *  polygon.c
 *
 *  This file contains the necessary driver routine to plot (XYpolygon)
 *  and fill (XYfillPolygon) arbitrary polygons.
 *
 *  Update History:
 *	March 1983 -- Written by David Kaelbling.
 */
 
#include <Vioprotocol.h> 
#include "Vgts.h"
#include "sdf.h"
#include "vgt.h"
#include "splines.h"
 
 
/* Imports */
extern XYbrush();		/* Line drawing routines. */
extern XYline();
extern XYfillInit();		/* Initializes the fill routines. */
extern XYfillLine();		/* Call once for each line segment. */
extern XYfillScreen();		/* Call after all lines are done. */
 
 
/* Exports */
extern XYpolygon();
extern XYfillPolygon();

/*
 *  XYpolygon()
 *
 *  A rather simple minded driver routine which plots the boundry of
 *  an arbitrary polygon.
 */
 
XYpolygon( vert, numvert, closed, clip, nib, view, dx, dy )
	register POINT vert[];
	register short numvert;
	BOOLEAN closed;
	register struct SubView *clip;
	register enum Nib nib;
	register View *view;
	register short dx, dy;
  {
    register short i;
    
    /* Do the obvious */
    for (i = 1;  i < numvert;  i++)
      {
        XYline(	XcvtToScreen( vert[i-1].x + dx, view ),
			YcvtToScreen( vert[i-1].y + dy, view ),
			XcvtToScreen( vert[i].x + dx, view ),
			YcvtToScreen( vert[i].y + dy, view ),
			XYbrush, clip, nib );
      }
      
    /* If a closed figure, draw the last line segment */
    if (closed)
      {
        XYline(	XcvtToScreen( vert[numvert-1].x + dx, view ),
			YcvtToScreen( vert[numvert-1].y + dy, view ),
			XcvtToScreen( vert[0].x + dx, view ),
			YcvtToScreen( vert[0].y + dy, view ),
			XYbrush, clip, nib );
      }
  }
 
/*
 *  XYfillPolygon()
 *
 *  A sample driver routine for the fill routines, it accepts a pointer
 *  to the pattern (16 shorts) to be used for filling, a pointer to an
 *  array of adjacent vertex points, the number of vertices, and the
 *  coordinates of the bounding box to be used during clipping.
 */
 
XYfillPolygon( pattern, opaque, vert, numVert, clip, view, dx, dy )
	enum Pattern pattern;
	unsigned short opaque;
	POINT vert[];
	short numVert;
	struct SubView *clip;
	View *view;
	register short dx, dy;
  {
    register short i;
    
    /* Do all of the work */
    if (XYfillInit( clip ) == ERROR)
        return( ERROR );
    
    /* Generate the points */
    for (i=1;  i < numVert;  i++)
      {
        XYfillLine( XcvtToScreen( vert[i-1].x + dx, view ),
		    YcvtToScreen( vert[i-1].y + dy, view ),
		    XcvtToScreen( vert[i].x + dx, view ),
		    YcvtToScreen( vert[i].y + dy, view ),
		    clip );
      }
    XYfillLine( XcvtToScreen( vert[numVert - 1].x + dx, view ),
		YcvtToScreen( vert[numVert - 1].y + dy, view ),
		XcvtToScreen( vert[0].x + dx, view ),
		YcvtToScreen( vert[0].y + dy, view ),
		clip );
    
    /* Display the results */
    XYfillScreen( pattern, opaque );
  }
