/************************************************/
/*						*/
/*	       (C)  COPYRIGHT 1984		*/
/*		BOARD OF TRUSTEES		*/
/*	LELAND STANFORD JUNIOR UNIVERSITY	*/
/*	  STANFORD, CA. 94305, U. S. A.		*/
/*						*/
/************************************************/
 
/* markers.c: definitions for the standard GKS marker styles, and the
 * table which maps marker indices to marker bitmaps.
 */

#include "Vgts.h"


static short Dot[] = {0, 0, 0, 0x1000, 0, 0, 0, 0};

static short Plus[] = {0x1000, 0x1000, 0x1000, 0xfe00,
			 0x1000, 0x1000, 0x1000, 0};

static short Asterisk[] = {0x1000, 0x5400, 0x3800, 0x1000,
			   0x3800, 0x5400, 0x1000, 0};

static short Circle[] = {0x3800, 0x4400, 0x8200, 0x8200,
			 0x8200, 0x4400, 0x3800, 0};

static short X[] = {0x8200, 0x4400, 0x2800, 0x1000,
		    0x2800, 0x4400, 0x8200, 0};

short *markerbits[MAX_MARKER_TYPE_INDEX] = {
    Dot,	/* GKS standard: no 0 index */
    Dot,
    Plus,
    Asterisk,
    Circle,
    X,
    };
