/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * keyboard.c - keyboard helper process 
 *
 * Bill Nowicki November 1982
 */

# include <Venviron.h>
# include <Vioprotocol.h>
# include <Vtermagent.h>
# include "Vgts.h"
# include <Vquerykernel.h>
# include <chars.h>
# include "sdf.h"
# include "vgt.h"

extern Process_id VgtsPid;
extern short InputVGT, TtyVGT;

KeyboardProcess()
  {
	/*
	 * read chars from the keyboard and send them to the Vgts
	 */
    short isCadlinc = FALSE, isAsciiTerminal = FALSE;
    int i;
    unsigned char *periphEntry;
    IoRequest msg;
    Message configMsg;
    register PeripheralConfigurationReply *configReply =
				(PeripheralConfigurationReply *) configMsg; 
    register char c;


    QueryKernel(0, PERIPHERAL_CONFIG, configMsg);
    periphEntry = configReply->peripheral;
    for (i = 0 ; i < MAX_PERIPHERALS ; i++, periphEntry++)
      {
	if (*periphEntry == PRF_CADLINC_KEYBOARD) {isCadlinc = TRUE; break;}
	else if (*periphEntry==PRF_ASCII_TERMINAL){isAsciiTerminal=TRUE;break;}
      }

    while (1)
      {
         c = getchar();
	 if ( c == EOF && stdin->lastexception == BAD_BLOCK_NO )
	   {
	     Resynch(stdin);
	     c = getchar();
	   }
	 msg.requestcode = (int)Keyboard;
	 msg.fileid = 0;
	 if (c & 0200 && isCadlinc)
	  switch ( c&0177 )
	    {
	     case 'v':  SendEscSequence('O','P');	continue;
	     case 'w':  SendEscSequence('O','Q');	continue;
	     case 'x':  SendEscSequence('O','R');	continue;
	     case 'y':  SendEscSequence('O','S');	continue;
	     case 'C':	/* "Enter" */			continue;
	     case 'q':  SendEscSequence('[','A');	continue;
	     case 'r':  SendEscSequence('[','B');	continue;
	     case 's':  SendEscSequence('[','D');	continue;
	     case 't':  SendEscSequence('[','C');	continue;
	     case 'S':	return;
	    }
	 if (isAsciiTerminal) c &= 0177;
         msg.shortbuffer[0] = c;
	 if (c==TELNET_ESCAPE)	/* should be "VGTS_ESCAPE" */
	   {
	   	/*
		 * Decode local window commands for those who do not have
		 * a mouse, or like using the keyboard.
		 */
	     char temp = getchar();

	     switch ( (int)(temp & 0177) )
	       {
	         case '1':  
	         case '2':  
	         case '3':
	         case '4':  
	         case '5':  
	         case '6':  
	         case '7':  
	         case '8':  
	         case '9':  
		     Select(temp-'0');
		     continue;

		 default:
		     Send( &msg, VgtsPid );
	 	     msg.requestcode = (int)Keyboard;
	             msg.shortbuffer[0] = temp;
		     msg.fileid = 0;
		     break;
	       }
	   }
	 Send( &msg, VgtsPid);
      }
  }


static SendEscSequence(c1, c2)
  char c1, c2;
  {
  	/*
	 * Send an escape followed by two characters
	 */
   IoRequest msg;

    msg.requestcode = (int)Keyboard;
    msg.shortbuffer[0] = ESC;
    msg.fileid = 0;
    Send( &msg, VgtsPid );
    msg.requestcode = (int)Keyboard;
    msg.shortbuffer[0] = c1;
    Send( &msg, VgtsPid );
    msg.requestcode = (int)Keyboard;
    msg.shortbuffer[0] = c2;
    Send( &msg, VgtsPid );   
  }

/*
 * GetInputChar:
 * Call for next keyboard input character from the vgts.
 */

char GetInputChar()
  {
    short savePad = InputVGT;
    IoReply msg;
    
    InputVGT = TtyVGT;
    GetMessage( 0, 1, &msg);
    InputVGT = savePad;
    return((char) msg.shortbuffer[0]);
  }


static Select(n)
  {
  	/*
	 * select for input. This routine is called from the
	 * keyboard process.
	 */
    IoRequest msg;
     
     msg.requestcode = (SystemCode)SwitchInput;
     msg.fileid = n;
     Send(&msg,VgtsPid);
  }
