/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1983			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/* init.c - Virtual Graphics Terminal Server Initialization
 *
 *
 * This provides the "main" program for the vgtsexec
 *
 * Bill Nowicki April 1983
 *
 * Marvin Theimer, 6/83:  Changed initialization to call InitFirstTeam
 *		to do the initialization of first team matters that is 
 *		common to all execs.
 */

# include <Venviron.h>
# include <Vioprotocol.h>
# include "Vgts.h"
# include "sdf.h"
# include "vgt.h"
# include <Vtermagent.h>

extern short TtyVGT, TtySDF;
extern short Unique, InputVGT;		/* From mux.c */
extern InitExec();
extern ProcessId execserver;
extern short Debug;
extern struct Buffer *CreateBuffer();

/*
 * main:
 * Main routine for the vgts package.
 * This routine sets up the vgts process and any applications
 * processes; in this case, Exec.
 */

main(argc, argv)
  int argc;
  char *argv[];
  {
    Message msg;
    short vgt;
    ProcessId initpid;
    Term1 *term1;
    Term2 *term2;

    /* argument, if given, is initial Debug in hex */
    if (argc > 1)  sscanf(argv[1], "%hx", &Debug);

#ifndef MC68000
    /* At present (12-Aug-85) we use the console serial line on the MicroVAX II,
     *   rather than the QVSS, for all I/O - in particular, we use the keyboard
     *   on the console serial line rather than the QVSS keyboard.  Here, we
     *   change stdin for the VGTS (and hence anything that use the VGTS for
     *   input) to be the keyboard on the QVSS.  Final twist: the QVSS keyboard
     *   is currently [device]serial0 (ugh).
     */
    freopen("[device]serial0", "r", stdin);
#endif MC68000

    InitVgts( 690, 698, 1100, 790 );

    vgt = NewTextVGT(TtySDF, "Executive", PadHeight, PadWidth);
    InputVGT = vgt;
    CreateView( vgt, 8, 304, 8+ViewWidth(PadWidth), 
    		304+ViewHeight(PadHeight), 0, 0, 0, 0);

    TtyMessage( "Virtual Graphics Terminal Service, version a.2" );
    TtyMessage( "With multiple executives" );
	/*
	 * set up stderr to go to the VGTS
	 */
    stderr = (File *)malloc(sizeof(File));
    *stderr = *stdout;
    stderr->fileid = TtyVGT;
    stderr->fileserver = GetPid(VGT_SERVER,ANY_PID);

    execserver = GetPid(EXEC_SERVER, LOCAL_PID);
    SpawnExec(InputVGT);

    /*
     * The main VGTS loop: wait for a message and take appropriate action,
     * forever.
     */
    while (1) GetMessage( 0, 0, msg );
 }


