/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1982			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/*
 * font.c - user interface for the font declaration stuff
 *
 * Bill Nowicki March 1983
 */

#include <Venviron.h>
#include <text.h>
#ifndef GREEP
#include <fonttable.h>
#else GREEP
#include <sfont.h>
#endif GREEP
#include <Vfont.h>
#include <rasterops.h>
#include <Vgtp.h>
#include "sdf.h"

extern short Debug, RowOrder;
extern int FontOptions;

extern FontTable Fonts;
static FontTable *junk = &Fonts;

DefineFont(name,fileName)
    char *name;
    char *fileName;
  {
    short code;

    if (strlen(fileName)==0) fileName = NULL;
    if (Debug & DebugVgtsFonts)
        dprintf("Starting to read font %s, file %s\n",name,fileName);
    code = GetFont(name,fileName, FontOptions);
    if (Debug & DebugVgtsFonts)
        dprintf("Done reading font %s, file %s, code=%d\n",
    		name,fileName,code);
    return(code);
  }


TextSize(text,font,pxmin,pxmax,pymin,pymax)
    TextStructure *text;
    short *pxmin, *pxmax, *pymin, *pymax;
  {
	/*
	 * Calculate the width and height of a string
	 */
    short left = *pxmin, base = *pymin;
    FontEntry *fontp, *LookupFont();
    fontp = LookupFont(font);

    if (!fontp)
      {
	if (Debug & DebugVgtsFonts)
	    dprintf("LookupFont %d returned null\n", font);
	*pxmax = left; *pymax = base;
      }
    else
      { struct fb_raster bBox; ScaledVector pos; int top;
	pos.h = left<<16; pos.v = 0;
	TextBBox(text->string, text->length,
	    fontp->font, &pos, &bBox, TextStdPaint);
	*pxmin = bBox.x;
	*pxmax = bBox.x + bBox.width - 1;
	top = base - bBox.y;
	*pymax = top;
	*pymin = top + 1 - bBox.height;
      }
  }


