/********************************************************/
/*							*/
/*	  Virtual Graphics Terminal Server		*/
/*							*/
/*		(C) COPYRIGHT 1983			*/
/*		BOARD OF TRUSTEES			*/
/*	LELAND STANFORD JUNIOR UNIVERSITY		*/
/*	  STANFORD, CA. 94305, U. S. A.			*/
/*							*/
/********************************************************/

/* dir.c - Directory Protocol implementation for the VGTS
 *
 *
 * Bill Nowicki September 1983
 *
 */

#include <Vioprotocol.h>
#include <Vdirectory.h>
#include <Vgts.h>
#include <Vgtp.h>
#include "sdf.h"
#include "vgt.h"
#include "pad.h"

extern short Debug;
static VgtDescriptor buf;

HandleDirectoryRead(msg,pid)
    register IoRequest *msg;
  {
      /*
       * read the indicated "block" of the directory
       */
     short vgtindex = msg->blocknumber;
     register VGT *vgt = VGTtable + vgtindex;
     register Term1 *term1;
     
     if (vgtindex >= DirectoryInstance)
       {
         msg->requestcode = END_OF_FILE;
	 msg->bytecount = 0;
	 Reply(msg,pid);
	 return;
       }
     if (msg->bytecount > VgtDescriptorSize() )
       {
         msg->requestcode = BAD_BYTE_COUNT;
	 msg ->bytecount = 0;
	 Reply(msg,pid);
	 return;
       }
     if (Debug & DebugVgtsMessages) 
	dprintf("Reading descriptor for vgt %d\n", vgtindex);
     term1 = Term1Table + vgtindex;
     buf.typeVGT = vgt->type;
     if (vgt->type != UNUSED)
       {
         buf.descriptortype = VGT_DESCRIPTOR;
         strcpy( buf.name, vgt->name);
	 if (vgt->banner)
	   strncpy( buf.banner, vgt->banner, VgtBannerLength);
	 else
	   strcpy( buf.banner, "");
	 if (vgt->type & TTY)
	   {
	     buf.lines = padPtr(term1)->length + 1;
	     buf.columns = padPtr(term1)->width + 1;
	   }
	 else
	   {
	     buf.lines = 0;
	     buf.columns = 0;
	   }
	 buf.mode = term1->mode;
	 buf.vgt = vgtindex;
	 buf.master = term1->master;
	 buf.ownerPid = term1->owner;
	 buf.breakPid = term2Ptr(term1)->termPid;
	 buf.fileid = vgtindex;
        }
      else buf.descriptortype = EMPTY_DESCRIPTOR;

      if (DifferentByteOrder(pid))
	  if (buf.descriptortype == VGT_DESCRIPTOR)
	      ByteSwapVgtDescriptor(&buf);
	  else if (buf.descriptortype == EMPTY_DESCRIPTOR)
	      ByteSwapEmptyDescriptor(&buf);
      msg->requestcode = MoveTo(pid,msg->bufferptr,&buf,msg->bytecount);
      if (msg->requestcode != OK) msg->bytecount = 0;
      Reply(msg,pid);     
  }

VgtDescriptorSize()
  { return sizeof buf; }
