/* debugvgts: puts the vgts in debugging mode */

/* invoke:  debugvgts debugcode pad
 *
 * If pad is -1, output goes to console, otherwise it goes to the named pad if
 * indeed it is a pad.  Debugcode is a bit vector, in hex, specifying what
 * sort of information is wanted; its elements are described in Vgtp.h.
 * A debug code of zero turns off debugging.
 *
 * a debug code of 'trace' does a trace of the top-level symbol of any
 * vgt. The "pad" is the vgt to trace, rather than the output pad (which
 * can be set with "debugvgts 0 pad". If the VGT is positive, the vgts will
 * pause after every entry. If it is negative, a continuous output stram
 * suitable for writing to a file (when run under the sts) is output
 */

#include <Vio.h>
#include <Vgts.h>
#include <Vgtp.h>

DebugServerRequest message;
ProcessId VgtsPid;

main(argc, argv)
  int argc;
  char *argv[];
  {
    if (argc != 3) 
      {
	printf("Usage: debugvgts <hex debugging code> <pad>\n");
        printf("       debugvgts trace <vgt>\n");
	exit(1);
      }
    message.requestcode = SET_DEBUG_MODE;
    message.fileid = atoi(argv[2]);
    if (*argv[1]=='t') 
	message.debugcode=0x3141;
    else
        sscanf(argv[1], "%x", &message.debugcode);
    VgtsPid = GetPid(VGT_SERVER, LOCAL_PID);
    Send(&message, VgtsPid);
  }
